<?php
if (!isset($_POST['opcion']) || $_POST['opcion'] !== 'guardar') {
    echo "<span style='color:red;'>Error: Operación no válida.</span>";
    exit;
}

if (!isset($_POST['nombre_jq']) || !isset($_POST['edad_jq'])) {
    echo "<span style='color:red;'>Error: Datos incompletos.</span>";
    exit;
}

$conexion = new mysqli("localhost", "root", "", "bd_prueba6");

if ($conexion->connect_error) {
    die("<span style='color:red;'>Error de conexión: " . $conexion->connect_error . "</span>");
}

$nombre_x = trim($_POST['nombre_jq']);
$edad_x = trim($_POST['edad_jq']);

if (empty($nombre_x) || empty($edad_x)) {
    echo "<span style='color:red;'>Por favor completa todos los campos.</span>";
    exit;
}

if (!is_numeric($edad_x) || $edad_x < 0 || $edad_x > 150) {
    echo "<span style='color:red;'>Por favor ingresa una edad válida.</span>";
    exit;
}

$stmt = $conexion->prepare("INSERT INTO registro (nombre_completo, edad) VALUES (?, ?)");
$stmt->bind_param("si", $nombre_x, $edad_x);

if ($stmt->execute()) {
    echo "<span style='color:blue;'>✅ Registro guardado con éxito: $nombre_x ($edad_x años)</span>";
} else {
    echo "<span style='color:red;'>❌ Error al guardar: " . $stmt->error . "</span>";
}

$stmt->close();
$conexion->close();
?>