# 🚀 Configuración de Hosting - server.gmacservice.com

## Credenciales Configuradas

### Base de Datos MySQL
- **Host**: localhost
- **Base de datos**: servidor_inventario_utensilios
- **Usuario**: administrador_servidor
- **Password**: Admin2025!

### Dominio
- **URL**: https://server.gmacservice.com
- **IP**: 50.6.193.66
- **Home Directory**: /home/server

## ✅ Estado del Proyecto

El archivo `config/config.php` ya está configurado con las credenciales de producción.

## 📦 Pasos para Subir al Hosting

### 1. Subir archivos por FTP/SFTP o Git

**Opción A: FTP/SFTP**
```
Host: server.gmacservice.com
Puerto: 21 (FTP) o 22 (SFTP)
Usuario: server
```

**Estructura en el servidor:**
```
/home/server/
├── public_html/          ← Contenido de carpeta 'public/'
│   ├── .htaccess
│   ├── index.php
│   ├── router.php
│   ├── assets/
│   └── api/
├── config/               ← Fuera de public_html
├── src/
├── views/
└── database/
```

**Opción B: Git (Recomendado)**
```bash
ssh server@server.gmacservice.com
cd /home/server
git clone https://github.com/Monty092003/repo-web.git inventario
```

### 2. Importar Base de Datos

Desde cPanel → phpMyAdmin:

1. **Crear base de datos** (si no existe):
   - Nombre: `servidor_inventario_utensilios`
   - Usuario: `administrador_servidor` (ya creado)

2. **Importar archivos SQL en este orden**:
   ```
   1. database/create_database.sql
   2. database/insert_initial_data.sql
   3. database/insert_usuarios_prueba.sql (opcional)
   ```

### 3. Configurar Permisos

```bash
chmod 755 /home/server/inventario/src/cache
chmod 755 /home/server/inventario/logs
chmod 644 /home/server/inventario/config/config.php
```

### 4. Configurar DocumentRoot

Si usas cPanel, el DocumentRoot debe apuntar a:
```
/home/server/inventario/public
```

O crear un enlace simbólico:
```bash
ln -s /home/server/inventario/public/* /home/server/public_html/
```

### 5. Verificar Instalación

Acceder a: **https://server.gmacservice.com**

**Usuarios de prueba:**
- Admin: `admin@cayejero.com` / `admin123`
- Encargado: `encargado@cayejero.com` / `encargado123`
- Auditor: `auditor@cayejero.com` / `auditor123`

⚠️ **IMPORTANTE**: Cambiar estas contraseñas después del primer login.

### 6. SSL/HTTPS

Si no tienes SSL configurado:
```bash
# Desde cPanel → SSL/TLS → AutoSSL
# O instalar Let's Encrypt manualmente
```

## 🔧 Configuración Adicional

### Variables de Entorno (Opcional)

En cPanel → PHP Selector → Options:
```
APP_ENV=production
```

### PHP Version

Asegúrate de tener **PHP 7.4+** activado en cPanel.

## 🐛 Troubleshooting

### Error: "No se puede conectar a la base de datos"
- Verifica que la base de datos `servidor_inventario_utensilios` existe
- Verifica que el usuario `administrador_servidor` tiene permisos

### Error 404 en rutas
- Verifica que `.htaccess` está en `/home/server/public_html/`
- Activa mod_rewrite en cPanel

### Estilos no cargan
- Verifica que `assets/` tiene permisos 755
- Limpia caché del navegador (Ctrl+Shift+R)

## 📞 Soporte

**Repositorio**: https://github.com/Monty092003/repo-web
**Documentación**: Ver INSTALACION.md

---

**✅ Proyecto listo para desplegar en https://server.gmacservice.com**
