# 📦 Guía de Instalación - Sistema de Gestión de Inventario

## Requisitos del Servidor

### Software necesario:
- **PHP**: 7.4 o superior (recomendado 8.0+)
- **MySQL**: 5.7 o superior / MariaDB 10.2+
- **Servidor Web**: Apache 2.4+ o Nginx
- **Extensiones PHP requeridas**:
  - PDO
  - pdo_mysql
  - mbstring
  - session
  - json

---

## 📋 Instalación en Hosting Compartido (cPanel/Plesk)

### Paso 1: Preparar archivos

1. **Descarga el proyecto** desde GitHub:
   ```bash
   git clone https://github.com/Monty092003/repo-web.git
   ```

2. **Estructura de carpetas en el hosting**:
   ```
   /home/usuario/
   ├── public_html/          ← Raíz web pública
   │   ├── .htaccess
   │   ├── index.php
   │   ├── router.php
   │   ├── assets/
   │   └── api/
   ├── config/               ← Fuera de public_html (más seguro)
   ├── src/
   ├── views/
   └── database/
   ```

3. **Sube los archivos por FTP/SFTP**:
   - Contenido de `public/` → `public_html/`
   - Resto de carpetas → fuera de `public_html/`

### Paso 2: Configurar Base de Datos

1. **Crear base de datos desde cPanel**:
   - Panel → MySQL Databases
   - Crear base: `inventario_utensilios`
   - Crear usuario y asignar todos los privilegios

2. **Importar estructura**:
   - phpMyAdmin → Importar
   - Seleccionar archivos en este orden:
     1. `database/create_database.sql`
     2. `database/insert_initial_data.sql`
     3. `database/insert_usuarios_prueba.sql` (opcional)

### Paso 3: Configurar credenciales

Editar `config/config.php`:

```php
// Configuración de la base de datos
define('DB_HOST', 'localhost');        // o IP del servidor MySQL
define('DB_NAME', 'inventario_utensilios');
define('DB_USER', 'tu_usuario_mysql');
define('DB_PASS', 'tu_password_mysql');

// Cambiar entorno a producción
define('APP_ENV', 'production');
```

### Paso 4: Configurar permisos

```bash
chmod 755 config/
chmod 644 config/config.php
chmod 755 src/cache/
chmod 644 src/cache/*
```

---

## 🖥️ Instalación en VPS/Cloud (Ubuntu/Debian)

### Paso 1: Instalar dependencias

```bash
# Actualizar sistema
sudo apt update && sudo apt upgrade -y

# Instalar Apache, PHP y MySQL
sudo apt install apache2 php php-mysql php-mbstring php-json mysql-server -y

# Habilitar módulos de Apache
sudo a2enmod rewrite
sudo systemctl restart apache2
```

### Paso 2: Clonar proyecto

```bash
cd /var/www/
sudo git clone https://github.com/Monty092003/repo-web.git inventario
cd inventario
```

### Paso 3: Configurar VirtualHost (Apache)

Crear `/etc/apache2/sites-available/inventario.conf`:

```apache
<VirtualHost *:80>
    ServerName tu-dominio.com
    DocumentRoot /var/www/inventario/public
    
    <Directory /var/www/inventario/public>
        Options -Indexes +FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>
    
    ErrorLog ${APACHE_LOG_DIR}/inventario-error.log
    CustomLog ${APACHE_LOG_DIR}/inventario-access.log combined
</VirtualHost>
```

Activar sitio:
```bash
sudo a2ensite inventario.conf
sudo systemctl reload apache2
```

### Paso 4: Configurar MySQL

```bash
sudo mysql -u root -p

CREATE DATABASE inventario_utensilios CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
CREATE USER 'inventario_user'@'localhost' IDENTIFIED BY 'password_seguro';
GRANT ALL PRIVILEGES ON inventario_utensilios.* TO 'inventario_user'@'localhost';
FLUSH PRIVILEGES;
EXIT;

# Importar SQL
mysql -u inventario_user -p inventario_utensilios < database/create_database.sql
mysql -u inventario_user -p inventario_utensilios < database/insert_initial_data.sql
```

### Paso 5: Permisos

```bash
sudo chown -R www-data:www-data /var/www/inventario
sudo chmod -R 755 /var/www/inventario
sudo chmod 755 /var/www/inventario/src/cache
```

---

## 🔐 Seguridad Post-Instalación

### 1. SSL/HTTPS (Let's Encrypt)
```bash
sudo apt install certbot python3-certbot-apache
sudo certbot --apache -d tu-dominio.com
```

### 2. Cambiar credenciales por defecto

Los usuarios de prueba son:
- **Admin**: `admin@cayejero.com` / `admin123`
- **Encargado**: `encargado@cayejero.com` / `encargado123`
- **Auditor**: `auditor@cayejero.com` / `auditor123`

⚠️ **IMPORTANTE**: Cambia estas contraseñas inmediatamente en producción.

### 3. Verificar configuración

Accede a tu dominio y verifica:
- ✅ Login funciona correctamente
- ✅ Rutas de navegación funcionan
- ✅ Assets (CSS, JS, imágenes) cargan
- ✅ Logo CAYEJERO visible

---

## 🎨 Características del Sistema

- **Tema CAYEJERO**: Negro/Naranja/Dorado gaming style
- **Módulos**:
  - Dashboard con métricas
  - Inventario de utensilios
  - Reportes y pérdidas
  - Gestión de usuarios
- **Roles**: Administrador, Encargado, Auditor

---

## 🐛 Solución de Problemas

### Error: "No se puede conectar a la base de datos"
- Verifica credenciales en `config/config.php`
- Asegura que el usuario MySQL tenga permisos
- Verifica que el servicio MySQL esté corriendo

### Error 404 en rutas
- Verifica que `mod_rewrite` esté habilitado (Apache)
- Revisa que `.htaccess` existe en la raíz web
- Verifica la configuración del VirtualHost

### Estilos no cargan (página blanca/sin colores)
- Verifica rutas de assets en el navegador (F12 → Network)
- Asegura que la carpeta `assets/` tenga permisos 755
- Revisa que las URLs en BASE_URL sean correctas

### Imágenes/Logo no aparece
- Verifica que `assets/images/logo_app.png` existe
- Permisos de carpeta assets: `chmod 755 assets/`

---

## 📞 Soporte

**Repositorio**: https://github.com/Monty092003/repo-web
**Documentación adicional**: Ver carpeta `docs/`

---

## 📝 Licencia

Sistema de Gestión de Inventario - CAYEJERO © 2025
