# Sistema de Gestión de Inventario de Utensilios de Cocina

## 📝 Descripción
Sistema web para control, registro y trazabilidad de utensilios de cocina con arquitectura n-capas monolítica en PHP.

## 🎯 Funcionalidades Principales
- ✅ Control de inventario con estados y ubicaciones
- ✅ Registro de entradas y salidas justificadas
- ✅ Auditoría completa de movimientos
- ✅ Reportes semanales y mensuales
- ✅ Sistema de roles y permisos
- ✅ Alertas de stock bajo

## 🏗️ Arquitectura
- **Presentación (UI)**: HTML, CSS, JavaScript
- **Lógica de Negocio (BLL)**: PHP Services
- **Acceso a Datos (DAL)**: PHP Repository Pattern
- **Base de Datos**: MySQL

## 👥 Roles de Usuario
- **Administrador**: Control total del sistema
- **Encargado de Cocina**: Gestión diaria de inventario
- **Auditor**: Solo lectura y reportes

## 📊 Módulos
1. Autenticación y Roles
2. Gestión de Utensilios
3. Movimientos de Inventario
4. Reportes y Estadísticas
5. Auditoría y Control

## 🚀 Instalación
[Instrucciones de instalación se completarán durante el desarrollo]

## 📁 Estructura del Proyecto
```
app-web-Enciso/
├── config/          # Configuraciones
├── src/
│   ├── DAL/         # Data Access Layer
│   ├── BLL/         # Business Logic Layer
│   ├── Models/      # Modelos de datos
│   └── Utils/       # Utilidades
├── public/          # Archivos públicos
├── views/           # Vistas HTML
├── assets/          # CSS, JS, imágenes
└── database/        # Scripts SQL
```