<?php
/**
 * Configuración principal del sistema
 * Sistema de Gestión de Inventario de Utensilios
 */

// Configuración de la base de datos - PRODUCCIÓN
define('DB_HOST', 'localhost');
define('DB_NAME', 'server_inventario_utensilios');
define('DB_USER', 'server_admin');
define('DB_PASS', 'Admin2025!');
define('DB_CHARSET', 'utf8mb4');

// Configuración de la aplicación
define('APP_NAME', 'Sistema de Gestión de Inventario');
define('APP_VERSION', '1.0.0');
define('APP_ENV', getenv('APP_ENV') ?: 'production'); // development, production

// Rutas del sistema
define('ROOT_PATH', dirname(__DIR__));
define('SRC_PATH', ROOT_PATH . '/src');
define('PUBLIC_PATH', ROOT_PATH . '/public');
define('VIEWS_PATH', ROOT_PATH . '/views');
define('ASSETS_PATH', ROOT_PATH . '/assets');

// Configuración de errores según el entorno
if (APP_ENV === 'production') {
    error_reporting(0);
    ini_set('display_errors', '0');
    ini_set('log_errors', '1');
    ini_set('error_log', ROOT_PATH . '/logs/error.log');
} else {
    error_reporting(E_ALL);
    ini_set('display_errors', '1');
}

// Variables PDO para conexión a la base de datos
$dsn = 'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=' . DB_CHARSET;
$username = DB_USER;
$password = DB_PASS;
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

// URLs del sistema - Configuración dinámica
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'] ?? 'localhost';
define('BASE_URL', $protocol . '://' . $host . '/app-web-Enciso/public');
define('ASSETS_URL', BASE_URL . '/assets');

// Configuración de sesiones
define('SESSION_NAME', 'INVENTARIO_SESSION');
define('SESSION_LIFETIME', 3600); // 1 hora en segundos

// Configuración de seguridad
define('PASSWORD_HASH_ALGO', PASSWORD_ARGON2ID);
define('CSRF_TOKEN_NAME', 'csrf_token');

// Configuración de reportes
define('REPORTS_PATH', ROOT_PATH . '/reports');
define('TEMP_PATH', ROOT_PATH . '/temp');

// Configuración de logs
define('LOGS_PATH', ROOT_PATH . '/logs');
define('LOG_LEVEL', 'INFO'); // DEBUG, INFO, WARNING, ERROR

// Timezone
date_default_timezone_set('America/Mexico_City');

// Configuración de errores según el entorno
if (APP_ENV === 'development') {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    define('DEBUG_MODE', true);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
    define('DEBUG_MODE', false);
}

// Función de utilidad para debugging
if (!function_exists('debug_log')) {
    function debug_log($message, $data = null) {
        if (DEBUG_MODE) {
            error_log('[DEBUG] ' . $message . ($data ? ' - Data: ' . print_r($data, true) : ''));
        }
    }
}

// Autoloader simple
spl_autoload_register(function ($class) {
    $paths = [
        SRC_PATH . '/Models/',
        SRC_PATH . '/DAL/',
        SRC_PATH . '/BLL/',
        SRC_PATH . '/Utils/'
    ];
    
    foreach ($paths as $path) {
        $file = $path . $class . '.php';
        if (file_exists($file)) {
            require_once $file;
            return;
        }
    }
});