-- ===============================================
-- Datos iniciales del sistema
-- ===============================================

USE inventario_utensilios;

-- ===============================================
-- USUARIOS INICIALES
-- ===============================================
INSERT INTO usuarios (nombre, email, password_hash, rol) VALUES 
-- Contraseña: admin123
('Administrador del Sistema', 'admin@sistema.com', '$argon2id$v=19$m=65536,t=4,p=3$YWJjZGVmZ2hpams$7GCnvq7w9kz8NUFhB+g8+g==', 'administrador'),
-- Contraseña: encargado123  
('Encargado de Cocina', 'encargado@cocina.com', '$argon2id$v=19$m=65536,t=4,p=3$bG1ub3BxcnN0dXY$8HCnvq7w9kz8NUFhB+g8+g==', 'encargado'),
-- Contraseña: auditor123
('Auditor General', 'auditor@sistema.com', '$argon2id$v=19$m=65536,t=4,p=3$d3h5ejEyMzQ1Ng$9ICnvq7w9kz8NUFhB+g8+g==', 'auditor');

-- ===============================================
-- UTENSILIOS INICIALES DE EJEMPLO
-- ===============================================
INSERT INTO utensilios (nombre, tipo, descripcion, cantidad_total, cantidad_disponible, cantidad_minima, estado, ubicacion, precio_unitario) VALUES 
-- Cuchillos
('Cuchillo Chef 20cm', 'cuchillo', 'Cuchillo profesional para chef de acero inoxidable', 5, 5, 2, 'excelente', 'Estación de Corte A', 450.00),
('Cuchillo Filetero', 'cuchillo', 'Cuchillo especializado para filetear pescado', 3, 3, 1, 'bueno', 'Estación de Pescados', 320.00),
('Cuchillo Pelador', 'cuchillo', 'Cuchillo pequeño para pelar frutas y verduras', 8, 7, 3, 'bueno', 'Estación de Verduras', 150.00),

-- Sartenes
('Sartén Antiadherente 24cm', 'sarten', 'Sartén con recubrimiento antiadherente', 6, 4, 2, 'bueno', 'Estación de Cocción 1', 280.00),
('Sartén de Hierro 28cm', 'sarten', 'Sartén de hierro fundido para altas temperaturas', 4, 3, 1, 'excelente', 'Estación de Cocción 2', 650.00),

-- Ollas
('Olla de Acero 5L', 'olla', 'Olla de acero inoxidable con tapa', 8, 6, 2, 'bueno', 'Estación de Cocción 1', 420.00),
('Olla de Presión 8L', 'olla', 'Olla de presión para cocción rápida', 3, 2, 1, 'regular', 'Estación de Cocción 3', 890.00),

-- Utensilios menores
('Cucharón de Acero', 'utensilio_menor', 'Cucharón de acero inoxidable', 12, 10, 4, 'bueno', 'Estación General', 85.00),
('Espátula de Silicón', 'utensilio_menor', 'Espátula resistente al calor', 15, 12, 5, 'excelente', 'Estación General', 65.00),
('Colador Grande', 'utensilio_menor', 'Colador de acero inoxidable', 4, 3, 1, 'bueno', 'Estación de Lavado', 180.00),

-- Electrodomésticos
('Batidora Industrial', 'electrodomestico', 'Batidora de pie de 5L', 2, 1, 1, 'excelente', 'Estación de Repostería', 2500.00),
('Licuadora Comercial', 'electrodomestico', 'Licuadora de alta velocidad', 3, 2, 1, 'bueno', 'Estación de Bebidas', 1800.00);

-- ===============================================
-- MOVIMIENTOS INICIALES DE EJEMPLO
-- ===============================================
INSERT INTO movimientos (id_utensilio, tipo_movimiento, cantidad, cantidad_anterior, cantidad_nueva, motivo, detalle_motivo, usuario_id) VALUES 
-- Entradas iniciales (inventario inicial)
(1, 'entrada', 5, 0, 5, 'Inventario inicial', 'Registro inicial del sistema', 1),
(2, 'entrada', 3, 0, 3, 'Inventario inicial', 'Registro inicial del sistema', 1),
(3, 'entrada', 8, 0, 8, 'Inventario inicial', 'Registro inicial del sistema', 1),
(4, 'entrada', 6, 0, 6, 'Inventario inicial', 'Registro inicial del sistema', 1),
(5, 'entrada', 4, 0, 4, 'Inventario inicial', 'Registro inicial del sistema', 1),

-- Algunas salidas de ejemplo
(3, 'salida', 1, 8, 7, 'Daño', 'Cuchillo con filo deteriorado, enviado a mantenimiento', 2),
(4, 'salida', 2, 6, 4, 'Uso', 'Sartenes en uso en servicio de banquetes', 2),
(7, 'salida', 1, 3, 2, 'Reparación', 'Válvula de seguridad requiere revisión', 2);

-- ===============================================
-- ALERTAS INICIALES
-- ===============================================
INSERT INTO alertas_sistema (tipo_alerta, id_utensilio, mensaje, nivel, usuario_destinatario) VALUES 
('stock_bajo', 7, 'Olla de Presión 8L tiene solo 2 unidades disponibles', 'warning', 1),
('utensilio_dañado', 3, 'Cuchillo Pelador requiere mantenimiento', 'info', 2),
('revision_pendiente', 7, 'Olla de Presión 8L requiere revisión de seguridad', 'critical', 1);