<?php
/**
 * PUNTO DE ENTRADA PRINCIPAL DEL SISTEMA
 * ejecutar con: php -S localhost:8000 public/server.php
 */

// Cargar configuración
require_once __DIR__ . '/../config/config.php';

// Autoloader simple
spl_autoload_register(function($class) {
    $paths = [
        __DIR__ . '/../src/Models/',
        __DIR__ . '/../src/DAL/', 
        __DIR__ . '/../src/BLL/',
        __DIR__ . '/../src/Utils/'
    ];
    
    foreach($paths as $path) {
        $file = $path . $class . '.php';
        if(file_exists($file)) {
            require_once $file;
            return;
        }
    }
});

// Usar el router para manejar todas las rutas
require_once __DIR__ . '/router.php';
?>