<?php
/**
 * PROCESADOR DE LOGIN LIMPIO Y DIRECTO
 */

// Ya no iniciar sesión aquí - se hace en el router

// Solo procesar si es POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: /app-web-Enciso/public/login');
    exit;
}

try {
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if (empty($email) || empty($password)) {
        throw new Exception('Por favor ingrese email y contraseña');
    }
    
    // Conexión directa a BD - PRODUCCIÓN
    $host = 'localhost';
    $dbname = 'server_inventario_utensilios';
    $username = 'server_admin';
    $db_password = 'Admin2025!';
    
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $db_password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Buscar usuario
    $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE email = ? AND activo = 1");
    $stmt->execute([$email]);
    $usuario = $stmt->fetch();
    
    if ($usuario && password_verify($password, $usuario['password_hash'])) {
        // Login exitoso
        $_SESSION['usuario_id'] = $usuario['id'];
        $_SESSION['usuario_nombre'] = $usuario['nombre'];
        $_SESSION['usuario_email'] = $usuario['email'];
        $_SESSION['usuario_rol'] = $usuario['rol'];
        
        // Actualizar último acceso
        $stmt = $pdo->prepare("UPDATE usuarios SET ultimo_acceso = NOW() WHERE id = ?");
        $stmt->execute([$usuario['id']]);
        
        // Redirección inmediata
        header('Location: /app-web-Enciso/public/dashboard');
        exit;
        
    } else {
        throw new Exception("Credenciales incorrectas");
    }
    
} catch (Exception $e) {
    $_SESSION['error'] = $e->getMessage();
    header('Location: /app-web-Enciso/public/login');
    exit;
}
?>