<?php
/**
 * ROUTER SIMPLE Y CLARO PARA EL SISTEMA
 */

// Iniciar sesión
session_start();

// Definir base URL para redirecciones
define('ROUTER_BASE', '/app-web-Enciso/public');

// Obtener la ruta actual
$uri = $_SERVER['REQUEST_URI'];
$path = parse_url($uri, PHP_URL_PATH);
$path = str_replace(ROUTER_BASE, '', $path); // Limpiar path base

// Si no hay path, usar '/'
if (empty($path) || $path === '') {
    $path = '/';
}

// Verificar si usuario está autenticado
$isAuthenticated = isset($_SESSION['usuario_id']) && !empty($_SESSION['usuario_id']);

// Si no está autenticado y trata de acceder a páginas protegidas
$paginasProtegidas = ['/dashboard', '/inventario', '/reportes', '/usuarios', '/configuracion'];
if (!$isAuthenticated && in_array($path, $paginasProtegidas)) {
    $path = '/login';
}

// Si está autenticado y trata de ir al login, redirigir al dashboard
if ($isAuthenticated && $path === '/login') {
    header('Location: ' . ROUTER_BASE . '/dashboard');
    exit;
}

// RUTAS DEL SISTEMA
switch ($path) {
    case '/':
    case '/login':
        if ($isAuthenticated) {
            header('Location: ' . ROUTER_BASE . '/dashboard');
            exit;
        }
        
        // Si es POST, procesar login
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            require_once __DIR__ . '/process-login.php';
        } else {
            require_once __DIR__ . '/../views/auth/login-simple.php';
        }
        break;
        
    case '/dashboard':
        if (!$isAuthenticated) {
            header('Location: ' . ROUTER_BASE . '/login');
            exit;
        }
        
        // Limpiar flag de login exitoso si existe
        if (isset($_SESSION['login_success'])) {
            unset($_SESSION['login_success']);
        }
        
        require_once __DIR__ . '/../views/dashboard-simple.php';
        break;
        
    case '/inventario':
        if (!$isAuthenticated) {
            header('Location: ' . ROUTER_BASE . '/login');
            exit;
        }
        require_once __DIR__ . '/../views/inventario/index.php';
        break;
        
    case '/inventario/agregar':
        if (!$isAuthenticated) {
            header('Location: ' . ROUTER_BASE . '/login');
            exit;
        }
        require_once __DIR__ . '/../views/inventario/agregar.php';
        break;
        
    case '/inventario/editar':
        if (!$isAuthenticated) {
            header('Location: ' . ROUTER_BASE . '/login');
            exit;
        }
        require_once __DIR__ . '/../views/inventario/editar.php';
        break;
        
    case '/inventario/ajustar-stock':
        if (!$isAuthenticated) {
            header('Location: ' . ROUTER_BASE . '/login');
            exit;
        }
        require_once __DIR__ . '/../views/inventario/ajustar-stock.php';
        break;
        
    case '/inventario/movimiento':
        if (!$isAuthenticated) {
            header('Location: ' . ROUTER_BASE . '/login');
            exit;
        }
        require_once __DIR__ . '/../views/inventario/movimiento.php';
        break;
        
    case '/inventario/detalles':
        if (!$isAuthenticated) {
            header('Location: ' . ROUTER_BASE . '/login');
            exit;
        }
        require_once __DIR__ . '/../views/inventario/detalles.php';
        break;
        
    case '/reportes':
        if (!$isAuthenticated) {
            header('Location: ' . ROUTER_BASE . '/login');
            exit;
        }
        require_once __DIR__ . '/../views/reportes/index-simple.php';
        break;
        
    case '/usuarios':
        if (!$isAuthenticated) {
            header('Location: ' . ROUTER_BASE . '/login');
            exit;
        }
        require_once __DIR__ . '/../views/usuarios/index.php';
        break;
        
    case '/usuarios/editar':
        if (!$isAuthenticated) {
            header('Location: ' . ROUTER_BASE . '/login');
            exit;
        }
        require_once __DIR__ . '/../views/usuarios/editar.php';
        break;
        
    case '/usuarios/perfil':
        if (!$isAuthenticated) {
            header('Location: ' . ROUTER_BASE . '/login');
            exit;
        }
        require_once __DIR__ . '/../views/usuarios/perfil.php';
        break;
        
    case '/usuarios/cambiar-password':
        if (!$isAuthenticated) {
            header('Location: ' . ROUTER_BASE . '/login');
            exit;
        }
        require_once __DIR__ . '/../views/usuarios/cambiar-password.php';
        break;
        
    case '/usuarios/agregar':
        if (!$isAuthenticated) {
            header('Location: ' . ROUTER_BASE . '/login');
            exit;
        }
        require_once __DIR__ . '/../views/usuarios/agregar.php';
        break;
        
    case '/logout':
        session_destroy();
        header('Location: ' . ROUTER_BASE . '/login');
        exit;
        break;
        
    default:
        // Página 404
        http_response_code(404);
        echo "<h1>404 - Página no encontrada</h1>";
        echo "<p>La página <strong>$path</strong> no existe.</p>";
        echo "<a href='/dashboard'>Ir al Dashboard</a>";
        break;
}
?>
