<?php
/**
 * Router para el servidor PHP built-in
 * Uso: php -S localhost:8000 -t public server.php
 */

$uri = $_SERVER['REQUEST_URI'];
$path = parse_url($uri, PHP_URL_PATH);

// Si es un archivo estático y existe, servirlo directamente
if (preg_match('/\.(css|js|png|jpg|jpeg|gif|svg|ico|woff|woff2|ttf|eot)$/', $path)) {
    // Intentar servir desde public
    $publicFile = __DIR__ . $path;
    if (file_exists($publicFile)) {
        return false;
    }
    
    // Intentar servir desde assets (un nivel arriba)
    $assetsFile = __DIR__ . '/../assets' . str_replace('/assets', '', $path);
    if (file_exists($assetsFile)) {
        $mimeTypes = [
            'css' => 'text/css',
            'js' => 'application/javascript',
            'png' => 'image/png',
            'jpg' => 'image/jpeg',
            'jpeg' => 'image/jpeg',
            'gif' => 'image/gif',
            'svg' => 'image/svg+xml',
            'ico' => 'image/x-icon',
            'woff' => 'font/woff',
            'woff2' => 'font/woff2',
            'ttf' => 'font/ttf',
            'eot' => 'application/vnd.ms-fontobject'
        ];
        
        $ext = pathinfo($assetsFile, PATHINFO_EXTENSION);
        if (isset($mimeTypes[$ext])) {
            header('Content-Type: ' . $mimeTypes[$ext]);
        }
        
        readfile($assetsFile);
        return true;
    }
    
    // Si no existe, retornar 404
    http_response_code(404);
    return true;
}

// Para todo lo demás, usar index.php
require_once __DIR__ . '/index.php';
?>
