<?php
/**
 * TEST DE CONEXIÓN A BASE DE DATOS
 * Prueba diferentes combinaciones de credenciales
 */

echo "<h2>Test de Conexión a Base de Datos</h2>";

// Intento 1: Credenciales actuales
echo "<h3>Intento 1: Credenciales configuradas</h3>";
$configs = [
    [
        'host' => 'localhost',
        'dbname' => 'servidor_inventario_utensilios',
        'user' => 'administrador_servidor',
        'pass' => 'Admin2025!'
    ],
    [
        'host' => 'localhost',
        'dbname' => 'server_servidor_inventario_utensilios',
        'user' => 'server_administrador_servidor',
        'pass' => 'Admin2025!'
    ],
    [
        'host' => 'localhost',
        'dbname' => 'inventario_utensilios',
        'user' => 'administrador_servidor',
        'pass' => 'Admin2025!'
    ]
];

foreach ($configs as $i => $config) {
    echo "<p><strong>Configuración " . ($i + 1) . ":</strong></p>";
    echo "<pre>";
    echo "Host: {$config['host']}\n";
    echo "Database: {$config['dbname']}\n";
    echo "User: {$config['user']}\n";
    echo "Password: " . str_repeat('*', strlen($config['pass'])) . "\n";
    echo "</pre>";
    
    try {
        $pdo = new PDO(
            "mysql:host={$config['host']};charset=utf8mb4",
            $config['user'],
            $config['pass']
        );
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        echo "<p style='color: green;'>✅ Conexión exitosa al servidor MySQL!</p>";
        
        // Listar bases de datos disponibles
        $stmt = $pdo->query("SHOW DATABASES");
        $databases = $stmt->fetchAll(PDO::FETCH_COLUMN);
        echo "<p><strong>Bases de datos disponibles:</strong></p>";
        echo "<ul>";
        foreach ($databases as $db) {
            echo "<li>$db</li>";
        }
        echo "</ul>";
        
        // Intentar conectar a la base específica
        try {
            $pdo2 = new PDO(
                "mysql:host={$config['host']};dbname={$config['dbname']};charset=utf8mb4",
                $config['user'],
                $config['pass']
            );
            echo "<p style='color: green;'>✅ Conexión exitosa a la base de datos '{$config['dbname']}'!</p>";
            
            // Listar tablas
            $stmt = $pdo2->query("SHOW TABLES");
            $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
            echo "<p><strong>Tablas en la base de datos:</strong></p>";
            if (count($tables) > 0) {
                echo "<ul>";
                foreach ($tables as $table) {
                    echo "<li>$table</li>";
                }
                echo "</ul>";
            } else {
                echo "<p style='color: orange;'>⚠️ La base de datos existe pero está vacía</p>";
            }
            
            break; // Si funciona, no probar más
        } catch (PDOException $e) {
            echo "<p style='color: orange;'>⚠️ No se pudo conectar a la base de datos '{$config['dbname']}': " . $e->getMessage() . "</p>";
        }
        
        break; // Si la conexión básica funciona, salir
    } catch (PDOException $e) {
        echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
    }
    echo "<hr>";
}
?>
