<?php
/**
 * Panel de Administración del Sistema
 * Monitoreo avanzado de rendimiento, seguridad y optimización
 */

require_once '../config/config.php';
require_once '../src/BLL/AuthService.php';

$authService = new AuthService();

// Verificar autenticación y permisos de administrador
$authService->verificarSesion();
if (!$authService->esAdministrador()) {
    header('Location: ../public/login.php?error=permisos_insuficientes');
    exit();
}

$usuario = $authService->getUsuarioActual();
$pageTitle = 'Administración del Sistema';
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/assets/css/app.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/assets/css/admin-panel.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
    <!-- Navbar -->
    <?php include 'partials/navbar.php'; ?>

    <div class="container-fluid py-4">
        <!-- Header -->
        <div class="row mb-4">
            <div class="col">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h1 class="h3 mb-0 text-gradient">
                            <i class="fas fa-cogs me-2"></i>Administración del Sistema
                        </h1>
                        <p class="text-muted mb-0">Monitoreo y optimización avanzada del sistema</p>
                    </div>
                    <div class="btn-toolbar" role="toolbar">
                        <div class="btn-group me-2">
                            <button type="button" class="btn btn-outline-primary" id="refreshSystem">
                                <i class="fas fa-sync-alt me-2"></i>Actualizar
                            </button>
                            <button type="button" class="btn btn-outline-warning" id="clearCache">
                                <i class="fas fa-broom me-2"></i>Limpiar Caché
                            </button>
                            <button type="button" class="btn btn-outline-success" id="optimizeSystem">
                                <i class="fas fa-rocket me-2"></i>Optimizar
                            </button>
                        </div>
                        <div class="btn-group">
                            <button type="button" class="btn btn-outline-info" id="exportReport">
                                <i class="fas fa-download me-2"></i>Exportar
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Estado General del Sistema -->
        <div class="row mb-4" id="systemStatus">
            <div class="col-12">
                <div class="alert alert-info d-flex align-items-center" id="systemAlert">
                    <div class="spinner-border spinner-border-sm me-3" role="status">
                        <span class="visually-hidden">Cargando...</span>
                    </div>
                    <strong>Cargando estado del sistema...</strong>
                </div>
            </div>
        </div>

        <!-- Métricas de Salud del Sistema -->
        <div class="row mb-4">
            <div class="col-xl-3 col-lg-6 mb-3">
                <div class="health-card">
                    <div class="health-icon bg-gradient-success">
                        <i class="fas fa-heartbeat"></i>
                    </div>
                    <div class="health-content">
                        <h6>Estado General</h6>
                        <div class="health-value" id="overallHealth">--</div>
                        <small class="text-muted" id="healthDetails">Verificando...</small>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-6 mb-3">
                <div class="health-card">
                    <div class="health-icon bg-gradient-primary">
                        <i class="fas fa-tachometer-alt"></i>
                    </div>
                    <div class="health-content">
                        <h6>Rendimiento</h6>
                        <div class="health-value" id="performanceScore">--</div>
                        <small class="text-muted" id="performanceDetails">Analizando...</small>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-6 mb-3">
                <div class="health-card">
                    <div class="health-icon bg-gradient-warning">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <div class="health-content">
                        <h6>Seguridad</h6>
                        <div class="health-value" id="securityLevel">--</div>
                        <small class="text-muted" id="securityDetails">Evaluando...</small>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-6 mb-3">
                <div class="health-card">
                    <div class="health-icon bg-gradient-info">
                        <i class="fas fa-memory"></i>
                    </div>
                    <div class="health-content">
                        <h6>Recursos</h6>
                        <div class="health-value" id="resourceUsage">--</div>
                        <small class="text-muted" id="resourceDetails">Midiendo...</small>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Monitoreo de Rendimiento -->
            <div class="col-xl-8 col-lg-7 mb-4">
                <div class="card admin-card">
                    <div class="card-header">
                        <h6 class="mb-0">
                            <i class="fas fa-chart-line me-2"></i>Monitoreo de Rendimiento
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="col-md-4">
                                <div class="metric-item">
                                    <small class="text-muted">Tiempo de Respuesta</small>
                                    <div class="metric-value" id="responseTime">-- ms</div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="metric-item">
                                    <small class="text-muted">Consultas Ejecutadas</small>
                                    <div class="metric-value" id="queryCount">--</div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="metric-item">
                                    <small class="text-muted">Uso de Memoria</small>
                                    <div class="metric-value" id="memoryUsage">-- MB</div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="chart-container">
                            <canvas id="performanceChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Panel de Control -->
            <div class="col-xl-4 col-lg-5 mb-4">
                <div class="card admin-card">
                    <div class="card-header">
                        <h6 class="mb-0">
                            <i class="fas fa-tools me-2"></i>Panel de Control
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="control-group mb-4">
                            <h6 class="control-title">Caché del Sistema</h6>
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span>Items en memoria:</span>
                                <span class="badge bg-primary" id="cacheItems">--</span>
                            </div>
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <span>Tamaño total:</span>
                                <span class="text-muted" id="cacheSize">-- MB</span>
                            </div>
                            <div class="d-grid gap-2">
                                <button class="btn btn-outline-warning btn-sm" id="clearCacheBtn">
                                    <i class="fas fa-trash me-2"></i>Limpiar Caché
                                </button>
                            </div>
                        </div>

                        <div class="control-group mb-4">
                            <h6 class="control-title">Optimización</h6>
                            <div class="d-grid gap-2">
                                <button class="btn btn-outline-success btn-sm" id="optimizeDatabase">
                                    <i class="fas fa-database me-2"></i>Optimizar BD
                                </button>
                                <button class="btn btn-outline-info btn-sm" id="generateReport">
                                    <i class="fas fa-file-alt me-2"></i>Generar Reporte
                                </button>
                            </div>
                        </div>

                        <div class="control-group">
                            <h6 class="control-title">Mantenimiento</h6>
                            <div class="d-grid gap-2">
                                <button class="btn btn-outline-secondary btn-sm" id="cleanupLogs">
                                    <i class="fas fa-file-text me-2"></i>Limpiar Logs
                                </button>
                                <button class="btn btn-outline-danger btn-sm" id="systemMaintenance">
                                    <i class="fas fa-wrench me-2"></i>Mantenimiento
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Eventos de Seguridad -->
            <div class="col-lg-6 mb-4">
                <div class="card admin-card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h6 class="mb-0">
                            <i class="fas fa-shield-alt me-2"></i>Eventos de Seguridad
                        </h6>
                        <span class="badge bg-warning" id="securityEventCount">--</span>
                    </div>
                    <div class="card-body">
                        <div class="security-events" id="securityEvents">
                            <div class="text-center py-4 text-muted">
                                <i class="fas fa-spinner fa-spin fa-2x mb-3"></i>
                                <div>Cargando eventos de seguridad...</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recomendaciones -->
            <div class="col-lg-6 mb-4">
                <div class="card admin-card">
                    <div class="card-header">
                        <h6 class="mb-0">
                            <i class="fas fa-lightbulb me-2"></i>Recomendaciones de Optimización
                        </h6>
                    </div>
                    <div class="card-body">
                        <div id="optimizationRecommendations">
                            <div class="text-center py-4 text-muted">
                                <i class="fas fa-spinner fa-spin fa-2x mb-3"></i>
                                <div>Analizando sistema...</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Información del Sistema -->
        <div class="row">
            <div class="col-12">
                <div class="card admin-card">
                    <div class="card-header">
                        <h6 class="mb-0">
                            <i class="fas fa-info-circle me-2"></i>Información del Sistema
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="system-info-item">
                                    <i class="fas fa-server text-primary me-2"></i>
                                    <strong>Servidor:</strong>
                                    <div class="text-muted" id="serverInfo">Cargando...</div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="system-info-item">
                                    <i class="fab fa-php text-primary me-2"></i>
                                    <strong>PHP:</strong>
                                    <div class="text-muted" id="phpVersion"><?php echo PHP_VERSION; ?></div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="system-info-item">
                                    <i class="fas fa-clock text-primary me-2"></i>
                                    <strong>Uptime:</strong>
                                    <div class="text-muted" id="systemUptime">Calculando...</div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="system-info-item">
                                    <i class="fas fa-calendar text-primary me-2"></i>
                                    <strong>Última actualización:</strong>
                                    <div class="text-muted" id="lastUpdate">--</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal de Confirmación -->
    <div class="modal fade" id="confirmationModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Confirmación</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body" id="confirmationMessage">
                    ¿Está seguro de que desea realizar esta acción?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-primary" id="confirmAction">Confirmar</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="<?php echo ASSETS_URL; ?>/js/admin-panel.js"></script>
</body>
</html>