<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Iniciar Sesión - Sistema de Gestión de Inventario</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        /* === ESTILOS CAYEJERO LOGIN === */
        body.login-page {
            background: linear-gradient(135deg, #0a0a0a, #1a1a1a) !important;
            min-height: 100vh;
        }
        
        .login-card {
            background: linear-gradient(135deg, #1a1a1a, #2a2a2a) !important;
            border: 3px solid rgba(255, 140, 0, 0.5) !important;
            border-radius: 20px !important;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.5) !important;
        }
        
        .logo-container {
            text-align: center;
        }
        
        .login-logo {
            max-width: 180px;
            height: auto;
            filter: drop-shadow(0 0 15px rgba(255, 140, 0, 0.6));
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.05); }
        }
        
        .card-title {
            color: #FFD700 !important;
            font-weight: 900 !important;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.8);
            font-size: 2rem !important;
        }
        
        .text-muted {
            color: #cccccc !important;
            font-weight: 600 !important;
        }
        
        .form-label {
            color: #FFD700 !important;
            font-weight: 700 !important;
            margin-bottom: 0.5rem;
        }
        
        .form-control {
            background-color: rgba(42, 42, 42, 0.8) !important;
            border: 2px solid rgba(255, 140, 0, 0.3) !important;
            color: #ffffff !important;
            font-weight: 500;
            padding: 0.75rem;
            border-radius: 8px;
        }
        
        .form-control:focus {
            background-color: rgba(42, 42, 42, 0.9) !important;
            border-color: #FFD700 !important;
            box-shadow: 0 0 10px rgba(255, 215, 0, 0.3) !important;
            color: #ffffff !important;
        }
        
        .form-control::placeholder {
            color: #999999;
        }
        
        .btn-login {
            background: linear-gradient(135deg, #FFD700, #FF8C00) !important;
            border: none !important;
            color: #000000 !important;
            font-weight: 800 !important;
            padding: 0.75rem !important;
            font-size: 1.1rem !important;
            border-radius: 8px !important;
            transition: all 0.3s ease !important;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(255, 140, 0, 0.5) !important;
            background: linear-gradient(135deg, #FF8C00, #FFD700) !important;
        }
        
        .form-check-label {
            color: #ffffff !important;
            font-weight: 500;
        }
        
        .alert {
            background-color: rgba(220, 53, 69, 0.2) !important;
            border: 2px solid #dc3545 !important;
            color: #ffffff !important;
            border-radius: 8px;
            font-weight: 600;
        }
        
        .text-center a {
            color: #FFD700 !important;
            font-weight: 600;
            text-decoration: none;
        }
        
        .text-center a:hover {
            color: #FF8C00 !important;
            text-decoration: underline;
        }
        
        .password-toggle {
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #FFD700;
        }
    </style>
</head>
<body class="login-page">
    <div class="container">
        <div class="row justify-content-center align-items-center min-vh-100">
            <div class="col-md-6 col-lg-4">
                <div class="card login-card shadow">
                    <div class="card-body p-5">
                        <!-- Logo y título -->
                        <div class="text-center mb-4">
                            <div class="logo-container mb-3">
                                <img src="/app-web-Enciso/public/assets/images/logo_app.png" alt="Cayejero Logo" class="login-logo">
                            </div>
                            <h2 class="card-title text-center mb-2">Iniciar Sesión</h2>
                            <p class="text-muted" style="font-weight: 500; font-size: 1.1rem;">Sistema de Gestión de Inventario</p>
                        </div>

                        <!-- Mensajes de error -->
                        <?php if (isset($_SESSION['error'])): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                <?php echo htmlspecialchars($_SESSION['error']); unset($_SESSION['error']); ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>

                        <!-- Formulario de login -->
                        <form id="loginForm" method="POST" action="/app-web-Enciso/public/login">
                            <div class="mb-3">
                                <label for="email" class="form-label">
                                    <i class="fas fa-envelope me-1"></i>Email
                                </label>
                                <input type="email" 
                                       class="form-control form-control-lg" 
                                       id="email" 
                                       name="email" 
                                       placeholder="Ingrese su email"
                                       required>
                            </div>

                            <div class="mb-3">
                                <label for="password" class="form-label">
                                    <i class="fas fa-lock me-1"></i>Contraseña
                                </label>
                                <div class="input-group">
                                    <input type="password" 
                                           class="form-control form-control-lg" 
                                           id="password" 
                                           name="password" 
                                           placeholder="Ingrese su contraseña"
                                           required>
                                    <button class="btn btn-outline-secondary" type="button" id="togglePassword">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </div>
                            </div>

                            <div class="mb-3 form-check">
                                <input type="checkbox" class="form-check-input" id="remember">
                                <label class="form-check-label" for="remember">
                                    Recordar sesión
                                </label>
                            </div>

                            <div class="d-grid mb-3">
                                <button type="submit" class="btn btn-primary btn-lg">
                                    <i class="fas fa-sign-in-alt me-2"></i>
                                    <span class="button-text">Iniciar Sesión</span>
                                </button>
                            </div>
                        </form>

                        <!-- Ayuda -->
                        <div class="text-center mt-3">
                            <small class="text-muted">
                                <i class="fas fa-info-circle me-1"></i>
                                Si olvidaste tu contraseña, contacta al administrador del sistema
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="text-center py-3">
        <small>Sistema de Gestión de Inventario v1.0.0 © 2025</small>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Toggle password visibility
        document.getElementById('togglePassword')?.addEventListener('click', function() {
            const password = document.getElementById('password');
            const icon = this.querySelector('i');
            
            if (password.type === 'password') {
                password.type = 'text';
                icon.className = 'fas fa-eye-slash';
            } else {
                password.type = 'password';
                icon.className = 'fas fa-eye';
            }
        });
    </script>
</body>
</html>
