<?php
// Obtener datos reales de la base de datos
try {
    $pdo = new PDO("mysql:host=localhost;dbname=server_inventario_utensilios;charset=utf8mb4", 'server_admin', 'Admin2025!');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Obtener métricas del inventario
    $stmt = $pdo->query("SELECT 
                            COUNT(*) as tipos_utensilios,
                            COALESCE(SUM(cantidad_total), 0) as items_totales
                         FROM utensilios WHERE activo = 1");
    $metricas = $stmt->fetch();
    
    // Contar alertas (items con stock bajo o agotado)
    $stmt = $pdo->query("SELECT COUNT(*) as alertas FROM utensilios WHERE cantidad_total <= cantidad_minima AND activo = 1");
    $alertas = $stmt->fetch();
    $metricas['alertas_activas'] = $alertas['alertas'];
    
    // Obtener pérdidas recientes (últimos 7 días)
    $stmt = $pdo->query("SELECT COUNT(*) as perdidas_recientes, COALESCE(SUM(cantidad), 0) as unidades_perdidas 
                         FROM movimientos_inventario 
                         WHERE tipo_movimiento = 'salida' 
                         AND fecha_movimiento >= DATE_SUB(NOW(), INTERVAL 7 DAY)");
    $perdidas_recientes = $stmt->fetch();
    $metricas['perdidas_recientes'] = $perdidas_recientes['perdidas_recientes'];
    $metricas['unidades_perdidas'] = $perdidas_recientes['unidades_perdidas'];
    
    // Obtener items con más pérdidas
    $stmt = $pdo->query("SELECT u.nombre, COUNT(m.id) as total_perdidas, SUM(m.cantidad) as unidades_perdidas 
                         FROM movimientos_inventario m
                         LEFT JOIN utensilios u ON m.utensilio_id = u.id
                         WHERE m.tipo_movimiento = 'salida' 
                         AND m.fecha_movimiento >= DATE_SUB(NOW(), INTERVAL 30 DAY)
                         GROUP BY m.utensilio_id
                         ORDER BY unidades_perdidas DESC 
                         LIMIT 5");
    $items_perdidos = $stmt->fetchAll();
    
} catch (Exception $e) {
    // Si hay error, usar datos por defecto
    $metricas = [
        'tipos_utensilios' => 0,
        'items_totales' => 0,
        'alertas_activas' => 0,
        'perdidas_recientes' => 0,
        'unidades_perdidas' => 0
    ];
    $items_perdidos = [];
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Sistema de Inventario CAYEJERO</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        /* === ESTILOS CAYEJERO DASHBOARD === */
        body {
            background: linear-gradient(135deg, #0a0a0a, #1a1a1a) !important;
            color: #ffffff !important;
            min-height: 100vh;
        }
        
        .titulo-principal {
            color: #FFD700 !important;
            font-weight: 900 !important;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.8);
        }
        
        .elegant-card {
            background: linear-gradient(135deg, #1a1a1a, #2a2a2a) !important;
            border: 2px solid rgba(255, 140, 0, 0.3) !important;
            border-radius: 15px !important;
            transition: all 0.3s ease !important;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.3) !important;
        }
        
        .elegant-card:hover {
            transform: translateY(-5px);
            border-color: rgba(255, 215, 0, 0.6) !important;
            box-shadow: 0 8px 15px rgba(255, 140, 0, 0.4) !important;
        }
        
        .metric-icon {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            color: #ffffff;
        }
        
        .gradient-primary {
            background: linear-gradient(135deg, #FFD700, #FF8C00);
        }
        
        .gradient-warning {
            background: linear-gradient(135deg, #FF8C00, #ff6b00);
        }
        
        .gradient-info {
            background: linear-gradient(135deg, #17a2b8, #0d7488);
        }
        
        .gradient-success {
            background: linear-gradient(135deg, #28a745, #1e7e34);
        }
        
        .action-card {
            background: linear-gradient(135deg, #1a1a1a, #2a2a2a) !important;
            border: 2px solid rgba(255, 140, 0, 0.3) !important;
            border-radius: 15px !important;
            transition: all 0.3s ease !important;
            height: 100%;
        }
        
        .action-card:hover {
            border-color: #FFD700 !important;
            box-shadow: 0 8px 15px rgba(255, 140, 0, 0.3) !important;
        }
        
        .action-icon {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1rem;
            font-size: 2rem;
            color: #ffffff;
        }
        
        .action-icon.success {
            background: linear-gradient(135deg, #28a745, #1e7e34);
        }
        
        .action-icon.danger {
            background: linear-gradient(135deg, #dc3545, #bd2130);
        }
        
        .action-icon.info {
            background: linear-gradient(135deg, #17a2b8, #0d7488);
        }
        
        .action-title {
            color: #FFD700 !important;
            font-weight: 800 !important;
            font-size: 1.5rem;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.8);
        }
        
        .action-description {
            color: #ffffff !important;
            font-weight: 500;
        }
        
        .btn-action {
            background: linear-gradient(135deg, #28a745, #1e7e34) !important;
            border: none !important;
            color: #ffffff !important;
            font-weight: 700 !important;
            padding: 0.6rem 1.5rem !important;
            border-radius: 8px !important;
            transition: all 0.3s ease !important;
        }
        
        .btn-action:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(40, 167, 69, 0.4) !important;
        }
        
        .btn-danger {
            background: linear-gradient(135deg, #dc3545, #bd2130) !important;
        }
        
        .btn-danger:hover {
            box-shadow: 0 4px 8px rgba(220, 53, 69, 0.4) !important;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #007bff, #0056b3) !important;
        }
        
        .btn-primary:hover {
            box-shadow: 0 4px 8px rgba(0, 123, 255, 0.4) !important;
        }
        
        .section-header {
            background: linear-gradient(135deg, rgba(255, 140, 0, 0.2), rgba(255, 215, 0, 0.1)) !important;
            border-left: 4px solid #FF8C00 !important;
            padding: 1rem !important;
            margin-bottom: 1.5rem !important;
            border-radius: 8px !important;
        }
        
        .section-title {
            color: #FFD700 !important;
            font-weight: 800 !important;
            margin: 0 !important;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.8);
        }
        
        .alert-box {
            background: linear-gradient(135deg, #1a1a1a, #2a2a2a) !important;
            border: 2px solid rgba(255, 140, 0, 0.3) !important;
            border-radius: 15px !important;
            padding: 2rem !important;
            text-align: center;
        }
        
        .alert-icon {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            background: linear-gradient(135deg, #28a745, #1e7e34);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1rem;
            font-size: 3rem;
            color: #ffffff;
        }
        
        .alert-title {
            color: #28a745 !important;
            font-weight: 800 !important;
            font-size: 1.8rem;
            margin-bottom: 0.5rem;
        }
        
        .alert-message {
            color: #ffffff !important;
            font-weight: 500;
        }
        
        /* Cards de acceso rápido */
        .card h6 {
            color: #FFD700 !important;
            font-weight: 800 !important;
            margin-bottom: 0.5rem;
        }
        
        .card p {
            color: #cccccc !important;
        }
        
        .card .fa-3x {
            opacity: 0.8;
        }
        
        .text-primary {
            color: #007bff !important;
        }
        
        .text-danger {
            color: #dc3545 !important;
        }
        
        .text-success {
            color: #28a745 !important;
        }
        
        .text-secondary {
            color: #6c757d !important;
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <?php include __DIR__ . '/partials/navbar-simple.php'; ?>
    
    <div class="container-fluid py-4">
        <!-- Header -->
        <div class="row">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div>
                        <h1 class="h2 mb-1 titulo-principal"><i class="fas fa-utensils me-2"></i>Sistema de Inventario de Utensilios de Cocina</h1>
                        <p class="text-muted mb-0">Bienvenido, <?php echo htmlspecialchars($_SESSION['usuario_nombre'] ?? 'Usuario'); ?>.</p>
                    </div>
                    <div class="text-end">
                        <small class="text-muted">Última actualización:<br><?php echo date('d/m/Y H:i'); ?></small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Cards de métricas simplificadas -->
        <div class="row mb-4">
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="elegant-card h-100">
                    <div class="card-body p-4">
                        <div class="d-flex align-items-center">
                            <div class="metric-icon gradient-primary me-3">
                                <i class="fas fa-utensils"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="small mb-1" style="color: #cccccc; font-weight: 600;">Tipos de Utensilios</div>
                                <div class="h4 mb-1 fw-bold" style="color: #FFD700; font-size: 2rem;"><?php echo $metricas['tipos_utensilios']; ?></div>
                                <div class="small" style="color: #ffffff; font-weight: 500;"><i class="fas fa-box" style="color: #FF8C00;"></i> <?php echo $metricas['items_totales']; ?> unidades totales</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-4">
                <div class="elegant-card h-100">
                    <div class="card-body p-4">
                        <div class="d-flex align-items-center">
                            <div class="metric-icon gradient-warning me-3">
                                <i class="fas fa-exclamation-triangle"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="small mb-1" style="color: #cccccc; font-weight: 600;">Alertas de Stock</div>
                                <div class="h4 mb-1 fw-bold" style="color: #FFD700; font-size: 2rem;"><?php echo $metricas['alertas_activas']; ?></div>
                                <div class="small" style="color: #ffffff; font-weight: 500;"><i class="fas fa-bell" style="color: #FF8C00;"></i> Items con stock bajo</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-4">
                <div class="elegant-card h-100">
                    <div class="card-body p-4">
                        <div class="d-flex align-items-center">
                            <div class="metric-icon gradient-info me-3">
                                <i class="fas fa-arrow-down"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="small mb-1" style="color: #cccccc; font-weight: 600;">Pérdidas (7 días)</div>
                                <div class="h4 mb-1 fw-bold" style="color: #FFD700; font-size: 2rem;"><?php echo $metricas['unidades_perdidas']; ?></div>
                                <div class="small" style="color: #ffffff; font-weight: 500;"><i class="fas fa-list" style="color: #FF8C00;"></i> <?php echo $metricas['perdidas_recientes']; ?> movimientos</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-4">
                <div class="elegant-card h-100">
                    <div class="card-body p-4">
                        <div class="d-flex align-items-center">
                            <div class="metric-icon gradient-success me-3">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="small mb-1" style="color: #cccccc; font-weight: 600;">Sistema</div>
                                <div class="h4 mb-1 fw-bold" style="color: #FFD700; font-size: 1.5rem;">Operativo</div>
                                <div class="small" style="color: #28a745; font-weight: 600;"><i class="fas fa-check"></i> Funcional</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Control de Pérdidas -->
        <div class="row">
            <div class="col-xl-8 mb-4">
                <div class="elegant-card h-100">
                    <div class="card-header border-0" style="background: rgba(255, 140, 0, 0.2); border-radius: 15px 15px 0 0; padding: 1rem 1.25rem;">
                        <h6 class="m-0 fw-bold" style="color: #FFD700;"><i class="fas fa-chart-bar me-2" style="color: #FF8C00;"></i>Gestión de Inventario</h6>
                    </div>
                    <div class="card-body" style="padding-top: 1.5rem;">
                        <div class="row g-3">
                            <div class="col-md-4">
                                <div class="elegant-card action-card h-100 text-center p-4" style="border: 2px solid rgba(40, 167, 69, 0.3); border-radius: 20px;">
                                    <i class="fas fa-plus-circle fa-3x mb-3" style="color: #28a745;"></i>
                                    <h5 class="fw-bold" style="color: #FFD700;">Entradas</h5>
                                    <p class="text-muted mb-3">Nuevos items al inventario</p>
                                    <a href="/app-web-Enciso/public/inventario" class="btn btn-success">
                                        <i class="fas fa-plus"></i> Agregar
                                    </a>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="elegant-card action-card h-100 text-center p-4" style="border: 2px solid rgba(220, 53, 69, 0.3); border-radius: 20px;">
                                    <i class="fas fa-minus-circle fa-3x mb-3" style="color: #dc3545;"></i>
                                    <h5 class="fw-bold" style="color: #FFD700;">Salidas (Pérdidas)</h5>
                                    <p class="text-muted mb-3">Items perdidos o descartados</p>
                                    <span class="badge bg-danger" style="font-size: 1rem; padding: 0.5rem 1rem;"><?php echo $metricas['unidades_perdidas']; ?> esta semana</span>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="elegant-card action-card h-100 text-center p-4" style="border: 2px solid rgba(23, 162, 184, 0.3); border-radius: 20px;">
                                    <i class="fas fa-clipboard-list fa-3x mb-3" style="color: #17a2b8;"></i>
                                    <h5 class="fw-bold" style="color: #FFD700;">Trazabilidad</h5>
                                    <p class="text-muted mb-3">Motivos obligatorios</p>
                                    <a href="/app-web-Enciso/public/reportes" class="btn btn-primary">
                                        <i class="fas fa-chart-line"></i> Ver Reportes
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-4 mb-4">
                <div class="elegant-card h-100">
                    <div class="card-header border-0" style="background: rgba(255, 140, 0, 0.2); border-radius: 15px 15px 0 0; padding: 1rem 1.25rem;">
                        <h6 class="m-0 fw-bold" style="color: #FFD700;"><i class="fas fa-exclamation-triangle me-2" style="color: #FF8C00;"></i>Items con Más Pérdidas</h6>
                    </div>
                    <div class="card-body">
                        <?php if (empty($items_perdidos)): ?>
                            <div class="text-center py-4">
                                <i class="fas fa-shield-alt fa-3x text-success mb-3"></i>
                                <h6 class="text-success">¡Excelente!</h6>
                                <p class="text-muted">No hay pérdidas recientes registradas</p>
                                <small class="text-muted">Sistema funcionando correctamente</small>
                            </div>
                        <?php else: ?>
                            <div class="space-y-3">
                                <?php foreach ($items_perdidos as $index => $item): ?>
                                    <div class="d-flex align-items-center p-3 rounded-3" style="background: rgba(248, 249, 250, 0.8); border-left: 4px solid #f5576c;">
                                        <div class="me-3">
                                            <div class="bg-danger text-white rounded-circle d-flex align-items-center justify-content-center fw-bold" style="width: 32px; height: 32px; font-size: 0.85rem;">
                                                <?php echo $index + 1; ?>
                                            </div>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="fw-bold mb-1" style="font-size: 0.95rem;"><?php echo htmlspecialchars($item['nombre']); ?></div>
                                            <div class="small text-muted">
                                                <i class="fas fa-arrow-up me-1"></i><?php echo $item['total_perdidas']; ?> movimientos
                                            </div>
                                        </div>
                                        <div>
                                            <span class="badge bg-danger"><?php echo $item['unidades_perdidas']; ?></span>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Accesos Rápidos -->
        <div class="row">
            <div class="col-md-3 mb-3">
                <div class="card text-center h-100">
                    <div class="card-body">
                        <i class="fas fa-boxes fa-3x text-primary mb-3"></i>
                        <h6>Ver Inventario</h6>
                        <p class="small text-muted">Gestionar utensilios</p>
                        <a href="/app-web-Enciso/public/inventario" class="btn btn-primary btn-sm">
                            <i class="fas fa-eye"></i> Acceder
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card text-center h-100">
                    <div class="card-body">
                        <i class="fas fa-chart-line fa-3x text-danger mb-3"></i>
                        <h6>Reportes de Pérdidas</h6>
                        <p class="small text-muted">Análisis de salidas</p>
                        <a href="/app-web-Enciso/public/reportes" class="btn btn-danger btn-sm">
                            <i class="fas fa-chart-bar"></i> Ver Reportes
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card text-center h-100">
                    <div class="card-body">
                        <i class="fas fa-plus fa-3x text-success mb-3"></i>
                        <h6>Agregar Items</h6>
                        <p class="small text-muted">Nuevos utensilios</p>
                        <a href="/app-web-Enciso/public/inventario/agregar" class="btn btn-success btn-sm">
                            <i class="fas fa-plus"></i> Agregar
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card text-center h-100">
                    <div class="card-body">
                        <i class="fas fa-cog fa-3x text-secondary mb-3"></i>
                        <h6>Configuración</h6>
                        <p class="small text-muted">Ajustes del sistema</p>
                        <span class="badge bg-success">Operativo</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

