<?php
/**
 * Dashboard principal del sistema
 * Panel interactivo con métricas, gráficos y widgets en tiempo real
 */

// Ya no necesitamos estos requires porque el dashboard se carga desde el router

$authService = new AuthService();
$dashboardService = new DashboardService();

// Verificar autenticación
$authService->verificarSesion();
$usuario = $authService->getUsuarioActual();

// Obtener datos del dashboard
try {
    $metricas = $dashboardService->obtenerMetricasPrincipales();
    $graficos = $dashboardService->obtenerDatosGraficos('semana');
    $topUtensilios = $dashboardService->obtenerTopUtensilios(8);
    $actividadReciente = $dashboardService->obtenerActividadReciente(10);
    $widgets = $dashboardService->obtenerWidgets($usuario->id);
} catch (Exception $e) {
    $error = $e->getMessage();
}

$pageTitle = 'Dashboard Principal';
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/assets/css/app.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/assets/css/dashboard.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
    <!-- Navbar -->
    <?php include 'partials/navbar.php'; ?>

    <div class="container-fluid py-4">
        <div class="row">
            <!-- Contenido Principal -->
            <main class="col-12">
                <!-- Header del Dashboard -->
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <div>
                        <h1 class="h2 mb-0">
                            <i class="fas fa-tachometer-alt me-2 text-primary"></i>
                            Dashboard Principal
                        </h1>
                        <p class="text-muted mb-0">
                            Bienvenido, <strong><?php echo htmlspecialchars($usuario->nombre); ?></strong> 
                            | Última actualización: <?php echo date('d/m/Y H:i'); ?>
                        </p>
                    </div>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <div class="btn-group me-2">
                            <button type="button" class="btn btn-sm btn-outline-primary" onclick="actualizarDashboard()">
                                <i class="fas fa-sync-alt me-1"></i>
                                Actualizar
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="configurarWidgets()">
                                <i class="fas fa-cog me-1"></i>
                                Configurar
                            </button>
                        </div>
                    </div>
                </div>

                <?php if (isset($error)): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <strong>Error:</strong> <?php echo htmlspecialchars($error); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                <?php endif; ?>

                <!-- Métricas Principales -->
                <div class="row mb-4">
                    <div class="col-xl-3 col-lg-6 mb-3">
                        <div class="metric-card bg-gradient-primary">
                            <div class="metric-icon">
                                <i class="fas fa-cubes"></i>
                            </div>
                            <div class="metric-content">
                                <div class="metric-value"><?php echo number_format($metricas['inventario']['total_items'] ?? 0); ?></div>
                                <div class="metric-label">Items Totales</div>
                                <div class="metric-sublabel"><?php echo $metricas['inventario']['total_utensilios'] ?? 0; ?> tipos de utensilios</div>
                            </div>
                            <div class="metric-trend">
                                <i class="fas fa-arrow-up"></i>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-lg-6 mb-3">
                        <div class="metric-card bg-gradient-success">
                            <div class="metric-icon">
                                <i class="fas fa-check-circle"></i>
                            </div>
                            <div class="metric-content">
                                <div class="metric-value"><?php echo number_format($metricas['inventario']['items_disponibles'] ?? 0); ?></div>
                                <div class="metric-label">Disponibles</div>
                                <div class="metric-sublabel"><?php echo $metricas['movimientos']['promedio_diario'] ?? 0; ?> mov/día promedio</div>
                            </div>
                            <div class="metric-trend">
                                <i class="fas fa-check"></i>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-lg-6 mb-3">
                        <div class="metric-card bg-gradient-warning">
                            <div class="metric-icon">
                                <i class="fas fa-exclamation-triangle"></i>
                            </div>
                            <div class="metric-content">
                                <div class="metric-value"><?php echo $metricas['alertas']['total'] ?? 0; ?></div>
                                <div class="metric-label">Alertas Activas</div>
                                <div class="metric-sublabel"><?php echo $metricas['alertas']['criticas'] ?? 0; ?> críticas</div>
                            </div>
                            <div class="metric-trend">
                                <?php if (($metricas['alertas']['criticas'] ?? 0) > 0): ?>
                                <i class="fas fa-exclamation text-danger"></i>
                                <?php else: ?>
                                <i class="fas fa-check text-success"></i>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-lg-6 mb-3">
                        <div class="metric-card bg-gradient-info">
                            <div class="metric-icon">
                                <i class="fas fa-exchange-alt"></i>
                            </div>
                            <div class="metric-content">
                                <div class="metric-value"><?php echo number_format($metricas['movimientos']['total_movimientos'] ?? 0); ?></div>
                                <div class="metric-label">Movimientos (30d)</div>
                                <div class="metric-sublabel">Balance: <?php echo ($metricas['movimientos']['balance'] ?? 0) > 0 ? '+' : ''; ?><?php echo $metricas['movimientos']['balance'] ?? 0; ?></div>
                            </div>
                            <div class="metric-trend">
                                <?php if (($metricas['movimientos']['balance'] ?? 0) > 0): ?>
                                <i class="fas fa-arrow-up text-success"></i>
                                <?php else: ?>
                                <i class="fas fa-arrow-down text-warning"></i>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Gráficos y Contenido Principal -->
                <div class="row mb-4">
                    <!-- Gráfico de Tendencias -->
                    <div class="col-lg-8 mb-3">
                        <div class="card dashboard-card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h5 class="mb-0">
                                    <i class="fas fa-chart-line me-2"></i>
                                    Tendencias de Movimientos
                                </h5>
                                <div class="btn-group btn-group-sm" role="group">
                                    <input type="radio" class="btn-check" name="periodoGrafico" id="semana" autocomplete="off" checked>
                                    <label class="btn btn-outline-primary" for="semana">7D</label>

                                    <input type="radio" class="btn-check" name="periodoGrafico" id="mes" autocomplete="off">
                                    <label class="btn btn-outline-primary" for="mes">30D</label>

                                    <input type="radio" class="btn-check" name="periodoGrafico" id="trimestre" autocomplete="off">
                                    <label class="btn btn-outline-primary" for="trimestre">90D</label>
                                </div>
                            </div>
                            <div class="card-body">
                                <canvas id="movimientosChart" height="100"></canvas>
                            </div>
                        </div>
                    </div>

                    <!-- Top Utensilios -->
                    <div class="col-lg-4 mb-3">
                        <div class="card dashboard-card">
                            <div class="card-header">
                                <h6 class="mb-0">
                                    <i class="fas fa-trophy me-2"></i>
                                    Utensilios Más Usados
                                </h6>
                            </div>
                            <div class="card-body p-0">
                                <div class="list-group list-group-flush">
                                    <?php foreach (array_slice($topUtensilios, 0, 5) as $index => $utensilio): ?>
                                    <div class="list-group-item d-flex align-items-center">
                                        <div class="rank-badge">
                                            <span class="rank-number"><?php echo $index + 1; ?></span>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <div class="utensilio-name"><?php echo htmlspecialchars($utensilio['nombre']); ?></div>
                                            <small class="text-muted"><?php echo $utensilio['total_movimientos']; ?> movimientos</small>
                                        </div>
                                        <div class="usage-percentage">
                                            <small class="text-primary fw-bold"><?php echo $utensilio['porcentaje_uso']; ?>%</small>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Alertas Críticas y Actividad Reciente -->
                <div class="row mb-4">
                    <!-- Alertas Críticas -->
                    <?php if ($metricas['alertas']['total'] > 0): ?>
                    <div class="col-lg-6 mb-3">
                        <div class="card dashboard-card border-warning">
                            <div class="card-header bg-warning bg-opacity-10">
                                <h6 class="mb-0">
                                    <i class="fas fa-bell me-2 text-warning"></i>
                                    Alertas Críticas
                                </h6>
                            </div>
                            <div class="card-body">
                                <?php foreach (array_slice($metricas['alertas']['detalle'], 0, 3) as $alerta): ?>
                                <div class="alert alert-<?php echo $alerta['nivel'] === 'critica' ? 'danger' : 'warning'; ?> alert-sm mb-2">
                                    <div class="d-flex align-items-center">
                                        <i class="fas fa-<?php echo $alerta['nivel'] === 'critica' ? 'exclamation-circle' : 'exclamation-triangle'; ?> me-2"></i>
                                        <div class="flex-grow-1">
                                            <strong><?php echo htmlspecialchars($alerta['utensilio_nombre']); ?></strong>
                                            <br><small><?php echo htmlspecialchars($alerta['mensaje']); ?></small>
                                        </div>
                                        <a href="<?php echo BASE_URL; ?>/utensilios/ver/<?php echo $alerta['utensilio_id']; ?>" 
                                           class="btn btn-sm btn-outline-<?php echo $alerta['nivel'] === 'critica' ? 'danger' : 'warning'; ?>">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                                
                                <?php if ($metricas['alertas']['total'] > 3): ?>
                                <div class="text-center mt-3">
                                    <a href="<?php echo BASE_URL; ?>/reportes/alertas" class="btn btn-sm btn-warning">
                                        Ver todas las alertas (<?php echo $metricas['alertas']['total']; ?>)
                                    </a>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Actividad Reciente -->
                    <div class="col-lg-<?php echo $metricas['alertas']['total'] > 0 ? '6' : '12'; ?> mb-3">
                        <div class="card dashboard-card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h6 class="mb-0">
                                    <i class="fas fa-clock me-2"></i>
                                    Actividad Reciente
                                </h6>
                                <a href="<?php echo BASE_URL; ?>/movimientos" class="btn btn-sm btn-outline-primary">
                                    Ver historial
                                </a>
                            </div>
                            <div class="card-body p-0">
                                <div class="timeline">
                                    <?php foreach (array_slice($actividadReciente, 0, 5) as $actividad): ?>
                                    <div class="timeline-item">
                                        <div class="timeline-marker bg-<?php echo $actividad['color']; ?>">
                                            <i class="fas <?php echo $actividad['icono']; ?>"></i>
                                        </div>
                                        <div class="timeline-content">
                                            <div class="timeline-title"><?php echo htmlspecialchars($actividad['titulo']); ?></div>
                                            <div class="timeline-description text-muted"><?php echo htmlspecialchars($actividad['descripcion']); ?></div>
                                            <div class="timeline-meta">
                                                <small class="text-muted">
                                                    <i class="fas fa-user me-1"></i><?php echo htmlspecialchars($actividad['usuario']); ?>
                                                    <i class="fas fa-clock ms-2 me-1"></i><?php echo date('d/m H:i', strtotime($actividad['fecha'])); ?>
                                                </small>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Acciones Rápidas -->
                <div class="row">
                    <div class="col-12">
                        <div class="card dashboard-card">
                            <div class="card-header">
                                <h6 class="mb-0">
                                    <i class="fas fa-bolt me-2"></i>
                                    Acciones Rápidas
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <?php if ($authService->esAdministrador() || $authService->tieneRol('encargado')): ?>
                                    <div class="col-md-3 mb-3">
                                        <a href="<?php echo BASE_URL; ?>/utensilios/crear" class="quick-action-card text-decoration-none">
                                            <div class="quick-action-icon bg-primary">
                                                <i class="fas fa-plus"></i>
                                            </div>
                                            <div class="quick-action-content">
                                                <h6>Nuevo Utensilio</h6>
                                                <small class="text-muted">Agregar al inventario</small>
                                            </div>
                                        </a>
                                    </div>
                                    <?php endif; ?>

                                    <?php if ($authService->esAdministrador() || $authService->tieneRol('encargado')): ?>
                                    <div class="col-md-3 mb-3">
                                        <a href="<?php echo BASE_URL; ?>/movimientos" class="quick-action-card text-decoration-none" 
                                           onclick="event.preventDefault(); registrarMovimientoRapido('entrada');">
                                            <div class="quick-action-icon bg-success">
                                                <i class="fas fa-arrow-down"></i>
                                            </div>
                                            <div class="quick-action-content">
                                                <h6>Registrar Entrada</h6>
                                                <small class="text-muted">Ingreso de items</small>
                                            </div>
                                        </a>
                                    </div>

                                    <div class="col-md-3 mb-3">
                                        <a href="<?php echo BASE_URL; ?>/movimientos" class="quick-action-card text-decoration-none"
                                           onclick="event.preventDefault(); registrarMovimientoRapido('salida');">
                                            <div class="quick-action-icon bg-warning">
                                                <i class="fas fa-arrow-up"></i>
                                            </div>
                                            <div class="quick-action-content">
                                                <h6>Registrar Salida</h6>
                                                <small class="text-muted">Retiro de items</small>
                                            </div>
                                        </a>
                                    </div>
                                    <?php endif; ?>

                                    <?php if (true): ?>
                                    <div class="col-md-3 mb-3">
                                        <a href="<?php echo BASE_URL; ?>/reportes" class="quick-action-card text-decoration-none">
                                            <div class="quick-action-icon bg-info">
                                                <i class="fas fa-chart-bar"></i>
                                            </div>
                                            <div class="quick-action-content">
                                                <h6>Generar Reporte</h6>
                                                <small class="text-muted">Análisis y estadísticas</small>
                                            </div>
                                        </a>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <!-- Modales -->
    
    <!-- Modal de Movimiento Rápido -->
    <div class="modal fade" id="movimientoRapidoModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="fas fa-bolt me-2"></i>
                        Movimiento Rápido
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="movimientoRapidoForm">
                        <input type="hidden" id="tipoMovimiento" name="tipo_movimiento">
                        
                        <div class="mb-3">
                            <label class="form-label">Utensilio</label>
                            <select class="form-select" name="id_utensilio" required>
                                <option value="">Seleccionar utensilio...</option>
                                <!-- Se llena dinámicamente -->
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Cantidad</label>
                            <input type="number" class="form-control" name="cantidad" min="1" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Motivo</label>
                            <input type="text" class="form-control" name="motivo" required 
                                   placeholder="Breve descripción del motivo">
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-primary" onclick="procesarMovimientoRapido()">
                        <i class="fas fa-save me-1"></i>
                        Registrar
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/assets/js/dashboard.js"></script>
    
    <script>
        // Configuración inicial
        const DASHBOARD_CONFIG = {
            baseUrl: '<?php echo BASE_URL; ?>',
            chartData: <?php echo json_encode($graficos); ?>,
            metricas: <?php echo json_encode($metricas); ?>,
            usuario: {
                id: <?php echo $usuario->id; ?>,
                nombre: '<?php echo htmlspecialchars($usuario->nombre); ?>',
                rol: '<?php echo $usuario->rol; ?>'
            }
        };
        
        // Inicializar dashboard
        document.addEventListener('DOMContentLoaded', function() {
            DashboardApp.init(DASHBOARD_CONFIG);
        });
    </script>
</body>
</html>
                        <a class="nav-link" href="<?php echo BASE_URL; ?>/reportes">
                            <i class="fas fa-chart-bar me-1"></i> Reportes
                        </a>
                    </li>
                    <?php if ($authService->esAdministrador()): ?>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo BASE_URL; ?>/usuarios">
                            <i class="fas fa-users me-1"></i> Usuarios
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
                
                <ul class="navbar-nav">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-user me-1"></i>
                            <?php echo htmlspecialchars($usuario->nombre); ?>
                            <span class="badge bg-secondary ms-1"><?php echo ucfirst($usuario->rol); ?></span>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>/perfil">
                                <i class="fas fa-user-cog me-2"></i> Mi Perfil
                            </a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>/logout">
                                <i class="fas fa-sign-out-alt me-2"></i> Cerrar Sesión
                            </a></li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Contenido principal -->
    <div class="container-fluid py-4">
        
        <!-- Encabezado -->
        <div class="row mb-4">
            <div class="col">
                <h1 class="h3 mb-0">Dashboard</h1>
                <p class="text-muted">Resumen general del inventario de utensilios</p>
            </div>
        </div>

        <!-- Mensaje de error si hay -->
        <?php if (isset($error)): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-triangle me-2"></i>
                Error cargando datos: <?php echo htmlspecialchars($error); ?>
            </div>
        <?php endif; ?>

        <!-- Tarjetas de estadísticas -->
        <div class="row mb-4">
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card bg-primary text-white h-100">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <div class="h5 mb-0 font-weight-bold">
                                    <?php echo $estadisticasInventario['generales']['activos'] ?? 0; ?>
                                </div>
                                <div class="small">Utensilios Activos</div>
                            </div>
                            <div class="h2">
                                <i class="fas fa-utensils"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card bg-success text-white h-100">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <div class="h5 mb-0 font-weight-bold">
                                    <?php echo $estadisticasInventario['generales']['items_disponibles'] ?? 0; ?>
                                </div>
                                <div class="small">Items Disponibles</div>
                            </div>
                            <div class="h2">
                                <i class="fas fa-check-circle"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card bg-warning text-white h-100">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <div class="h5 mb-0 font-weight-bold">
                                    <?php echo $estadisticasInventario['generales']['con_stock_bajo'] ?? 0; ?>
                                </div>
                                <div class="small">Stock Bajo</div>
                            </div>
                            <div class="h2">
                                <i class="fas fa-exclamation-triangle"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card bg-info text-white h-100">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <div class="h5 mb-0 font-weight-bold">
                                    <?php echo $estadisticasMovimientos['generales']['total_movimientos'] ?? 0; ?>
                                </div>
                                <div class="small">Movimientos (7 días)</div>
                            </div>
                            <div class="h2">
                                <i class="fas fa-exchange-alt"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Contenido principal en dos columnas -->
        <div class="row">
            <!-- Columna izquierda -->
            <div class="col-lg-8">
                
                <!-- Gráfico de actividad -->
                <div class="card mb-4">
                    <div class="card-header">
                        <i class="fas fa-chart-line me-2"></i>
                        Actividad Semanal
                    </div>
                    <div class="card-body">
                        <canvas id="activityChart" height="100"></canvas>
                    </div>
                </div>

                <!-- Movimientos recientes -->
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <div>
                            <i class="fas fa-clock me-2"></i>
                            Movimientos Recientes
                        </div>
                        <a href="<?php echo BASE_URL; ?>/movimientos" class="btn btn-sm btn-outline-primary">
                            Ver todos
                        </a>
                    </div>
                    <div class="card-body">
                        <?php if (!empty($movimientosRecientes)): ?>
                            <div class="table-responsive">
                                <table class="table table-sm">
                                    <thead>
                                        <tr>
                                            <th>Fecha</th>
                                            <th>Utensilio</th>
                                            <th>Tipo</th>
                                            <th>Cantidad</th>
                                            <th>Motivo</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($movimientosRecientes as $movimiento): ?>
                                            <tr>
                                                <td class="text-muted small">
                                                    <?php echo $movimiento->getFechaFormateada(); ?>
                                                </td>
                                                <td><?php echo htmlspecialchars($movimiento->nombre_utensilio ?? 'N/A'); ?></td>
                                                <td>
                                                    <span class="badge bg-<?php echo $movimiento->getClaseTipo(); ?>">
                                                        <i class="<?php echo $movimiento->getIconoTipo(); ?> me-1"></i>
                                                        <?php echo ucfirst($movimiento->tipo_movimiento); ?>
                                                    </span>
                                                </td>
                                                <td><?php echo $movimiento->getImpacto(); ?></td>
                                                <td class="text-muted small"><?php echo htmlspecialchars($movimiento->motivo); ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <p class="text-muted text-center py-3">
                                <i class="fas fa-info-circle me-2"></i>
                                No hay movimientos recientes
                            </p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Columna derecha -->
            <div class="col-lg-4">
                
                <!-- Alertas de stock bajo -->
                <div class="card mb-4">
                    <div class="card-header bg-warning text-dark">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        Alertas de Stock Bajo
                    </div>
                    <div class="card-body">
                        <?php if (!empty($utensiliosStockBajo)): ?>
                            <?php foreach ($utensiliosStockBajo as $utensilio): ?>
                                <div class="alert alert-warning alert-sm mb-2">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong><?php echo htmlspecialchars($utensilio->nombre); ?></strong>
                                            <br><small>Disponible: <?php echo $utensilio->cantidad_disponible; ?></small>
                                        </div>
                                        <span class="badge bg-warning">
                                            <?php echo $utensilio->cantidad_disponible; ?>/<?php echo $utensilio->cantidad_minima; ?>
                                        </span>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <p class="text-success text-center py-3">
                                <i class="fas fa-check-circle me-2"></i>
                                No hay alertas de stock bajo
                            </p>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Enlaces rápidos -->
                <div class="card">
                    <div class="card-header">
                        <i class="fas fa-bolt me-2"></i>
                        Acciones Rápidas
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <?php if ($authService->tieneRol('administrador') || $authService->tieneRol('encargado')): ?>
                                <a href="<?php echo BASE_URL; ?>/utensilios/nuevo" class="btn btn-primary">
                                    <i class="fas fa-plus me-2"></i> Agregar Utensilio
                                </a>
                                <a href="<?php echo BASE_URL; ?>/movimientos/entrada" class="btn btn-success">
                                    <i class="fas fa-arrow-up me-2"></i> Registrar Entrada
                                </a>
                                <a href="<?php echo BASE_URL; ?>/movimientos/salida" class="btn btn-danger">
                                    <i class="fas fa-arrow-down me-2"></i> Registrar Salida
                                </a>
                            <?php endif; ?>
                            <a href="<?php echo BASE_URL; ?>/reportes" class="btn btn-info">
                                <i class="fas fa-chart-bar me-2"></i> Ver Reportes
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="<?php echo ASSETS_URL; ?>/js/dashboard.js"></script>
    
    <script>
        // Datos para el gráfico de actividad
        const activityData = <?php echo json_encode($estadisticasMovimientos['actividad_diaria'] ?? []); ?>;
    </script>
</body>
</html>