<?php
/**
 * PÁGINA PARA AGREGAR NUEVO UTENSILIO
 */

// Verificar autenticación
if (!isset($_SESSION['usuario_id'])) {
    header('Location: /app-web-Enciso/public/login');
    exit;
}

// Procesar formulario si es POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $pdo = new PDO("mysql:host=localhost;dbname=server_inventario_utensilios;charset=utf8mb4", 'server_admin', 'Admin2025!');
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        $nombre = $_POST['nombre'] ?? '';
        $descripcion = $_POST['descripcion'] ?? '';
        $categoria = $_POST['categoria'] ?? '';
        $cantidad_total = (int)($_POST['cantidad_total'] ?? 0);
        $ubicacion = $_POST['ubicacion'] ?? '';
        $estado = $_POST['estado'] ?? 'disponible';
        
        if (empty($nombre) || empty($categoria) || $cantidad_total <= 0) {
            throw new Exception('Por favor complete todos los campos requeridos');
        }
        
        $stmt = $pdo->prepare("INSERT INTO utensilios (nombre, descripcion, categoria, cantidad_total, ubicacion, estado, cantidad_minima) VALUES (?, ?, ?, ?, ?, ?, 5)");
        $stmt->execute([$nombre, $descripcion, $categoria, $cantidad_total, $ubicacion, $estado]);
        
        $_SESSION['success'] = 'Utensilio agregado exitosamente';
        header('Location: /app-web-Enciso/public/inventario');
        exit;
        
    } catch (Exception $e) {
        $error = $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Agregar Utensilio - Sistema de Inventario</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="../../assets/css/dashboard.css?v=<?php echo time(); ?>" rel="stylesheet">
    <link href="../../assets/css/utensilios.css?v=<?php echo time(); ?>" rel="stylesheet">
</head>
<body>
    <!-- Navbar -->
    <?php include __DIR__ . '/../partials/navbar-simple.php'; ?>
    
    <div class="container-fluid py-4">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <!-- Header -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2><i class="fas fa-plus text-primary"></i> Agregar Nuevo Utensilio</h2>
                    <a href="/app-web-Enciso/public/inventario" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Volver al Inventario
                    </a>
                </div>

                <!-- Mensajes -->
                <?php if (isset($error)): ?>
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-triangle"></i> <?php echo htmlspecialchars($error); ?>
                    </div>
                <?php endif; ?>

                <!-- Formulario -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-utensils"></i> Información del Utensilio</h5>
                    </div>
                    <div class="card-body">
                        <form method="POST">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="nombre" class="form-label">Nombre *</label>
                                    <input type="text" class="form-control" id="nombre" name="nombre" 
                                           value="<?php echo htmlspecialchars($_POST['nombre'] ?? ''); ?>" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="categoria" class="form-label">Categoría *</label>
                                    <select class="form-control" id="categoria" name="categoria" required>
                                        <option value="">Seleccione una categoría</option>
                                        <option value="Cubiertos" <?php echo ($_POST['categoria'] ?? '') === 'Cubiertos' ? 'selected' : ''; ?>>Cubiertos</option>
                                        <option value="Platos" <?php echo ($_POST['categoria'] ?? '') === 'Platos' ? 'selected' : ''; ?>>Platos</option>
                                        <option value="Vasos" <?php echo ($_POST['categoria'] ?? '') === 'Vasos' ? 'selected' : ''; ?>>Vasos</option>
                                        <option value="Jarras" <?php echo ($_POST['categoria'] ?? '') === 'Jarras' ? 'selected' : ''; ?>>Jarras</option>
                                        <option value="Cocina" <?php echo ($_POST['categoria'] ?? '') === 'Cocina' ? 'selected' : ''; ?>>Cocina</option>
                                        <option value="Otros" <?php echo ($_POST['categoria'] ?? '') === 'Otros' ? 'selected' : ''; ?>>Otros</option>
                                    </select>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="descripcion" class="form-label">Descripción</label>
                                <textarea class="form-control" id="descripcion" name="descripcion" rows="3" 
                                          placeholder="Descripción detallada del utensilio..."><?php echo htmlspecialchars($_POST['descripcion'] ?? ''); ?></textarea>
                            </div>

                            <div class="row">
                                <div class="col-md-4 mb-3">
                                    <label for="cantidad_total" class="form-label">Cantidad Total *</label>
                                    <input type="number" class="form-control" id="cantidad_total" name="cantidad_total" 
                                           value="<?php echo htmlspecialchars($_POST['cantidad_total'] ?? ''); ?>" min="1" required>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="ubicacion" class="form-label">Ubicación</label>
                                    <select class="form-control" id="ubicacion" name="ubicacion">
                                        <option value="">Seleccione ubicación</option>
                                        <option value="Cajón de Cubiertos - Comedor" <?php echo ($_POST['ubicacion'] ?? '') === 'Cajón de Cubiertos - Comedor' ? 'selected' : ''; ?>>Cajón de Cubiertos - Comedor</option>
                                        <option value="Estantería de Vajilla - Comedor" <?php echo ($_POST['ubicacion'] ?? '') === 'Estantería de Vajilla - Comedor' ? 'selected' : ''; ?>>Estantería de Vajilla - Comedor</option>
                                        <option value="Estantería de Cristalería - Bar" <?php echo ($_POST['ubicacion'] ?? '') === 'Estantería de Cristalería - Bar' ? 'selected' : ''; ?>>Estantería de Cristalería - Bar</option>
                                        <option value="Área de Preparación - Cocina" <?php echo ($_POST['ubicacion'] ?? '') === 'Área de Preparación - Cocina' ? 'selected' : ''; ?>>Área de Preparación - Cocina</option>
                                        <option value="Almacén General" <?php echo ($_POST['ubicacion'] ?? '') === 'Almacén General' ? 'selected' : ''; ?>>Almacén General</option>
                                    </select>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="estado" class="form-label">Estado Inicial</label>
                                    <select class="form-control" id="estado" name="estado">
                                        <option value="disponible" <?php echo ($_POST['estado'] ?? 'disponible') === 'disponible' ? 'selected' : ''; ?>>Disponible</option>
                                        <option value="mantenimiento" <?php echo ($_POST['estado'] ?? '') === 'mantenimiento' ? 'selected' : ''; ?>>En Reparación</option>
                                    </select>
                                    <div class="form-text">Normalmente será "Disponible"</div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12">
                                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                        <a href="/app-web-Enciso/public/inventario" class="btn btn-secondary me-md-2">
                                            <i class="fas fa-times"></i> Cancelar
                                        </a>
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-save"></i> Guardar Utensilio
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>


