<?php
/**
 * PÁGINA DE DETALLES DEL UTENSILIO
 */

// Verificar autenticación
if (!isset($_SESSION['usuario_id'])) {
    header('Location: /app-web-Enciso/public/login');
    exit;
}

// Obtener ID del utensilio
$utensilio_id = $_GET['id'] ?? null;
if (!$utensilio_id) {
    $_SESSION['error'] = 'ID de utensilio no válido';
    header('Location: /app-web-Enciso/public/inventario');
    exit;
}

try {
    $pdo = new PDO("mysql:host=localhost;dbname=server_inventario_utensilios;charset=utf8mb4", 'server_admin', 'Admin2025!');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Obtener datos del utensilio
    $stmt = $pdo->prepare("SELECT * FROM utensilios WHERE id = ?");
    $stmt->execute([$utensilio_id]);
    $utensilio = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$utensilio) {
        $_SESSION['error'] = 'Utensilio no encontrado';
        header('Location: /app-web-Enciso/public/inventario');
        exit;
    }
    
    // Obtener todos los movimientos
    $stmt = $pdo->prepare("SELECT m.*, u.nombre as usuario_nombre FROM movimientos_inventario m 
                           LEFT JOIN usuarios u ON m.usuario_id = u.id 
                           WHERE m.utensilio_id = ? ORDER BY m.fecha_movimiento DESC LIMIT 50");
    $stmt->execute([$utensilio_id]);
    $movimientos = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Estadísticas simplificadas
    $stmt = $pdo->prepare("SELECT 
        COUNT(*) as total_movimientos,
        SUM(CASE WHEN tipo_movimiento = 'entrada' THEN cantidad ELSE 0 END) as total_entradas,
        SUM(CASE WHEN tipo_movimiento = 'salida' THEN cantidad ELSE 0 END) as total_salidas
        FROM movimientos_inventario WHERE utensilio_id = ?");
    $stmt->execute([$utensilio_id]);
    $estadisticas = $stmt->fetch(PDO::FETCH_ASSOC);
    
} catch (Exception $e) {
    $error = $e->getMessage();
}

// Función para obtener el icono según el tipo de movimiento
function getMovementIcon($tipo) {
    switch($tipo) {
        case 'entrada': return 'fas fa-arrow-down text-success';
        case 'salida': return 'fas fa-arrow-up text-danger';
        default: return 'fas fa-circle text-secondary';
    }
}

// Función para obtener el color del badge según el tipo
function getBadgeClass($tipo) {
    switch($tipo) {
        case 'entrada': return 'bg-success';
        case 'salida': return 'bg-danger';
        default: return 'bg-secondary';
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detalles del Utensilio - Sistema CAYEJERO</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="../../assets/css/dashboard.css?v=20251210005" rel="stylesheet">
    <link href="../../assets/css/utensilios.css?v=20251210005" rel="stylesheet">
    <link href="../../assets/css/form-utensilio.css?v=20251210005" rel="stylesheet">
    <style>
        /* CAYEJERO - Forzar tema oscuro */
        body, html { background: #0a0a0a !important; }
        .container-fluid { background: #0a0a0a !important; }
        
        /* FORZAR TEXTOS VISIBLES SIEMPRE - Tamaño normal */
        .card-body * { 
            color: #ffffff !important; 
            font-weight: 700 !important;
            text-shadow: 1px 1px 3px rgba(0, 0, 0, 1) !important;
        }
        
        /* Primera columna (labels) en DORADO MUY BRILLANTE */
        .card-body .row > div:first-child,
        .card-body .row > .col-md-6:first-child,
        .card-body .col:first-child { 
            color: #FFD700 !important; 
            font-weight: 800 !important;
            text-shadow: 1px 1px 3px rgba(0, 0, 0, 1), 0 0 10px rgba(255, 215, 0, 0.5) !important;
        }
        
        /* Segunda columna (valores) en BLANCO BRILLANTE */
        .card-body .row > div:last-child,
        .card-body .row > .col-md-6:last-child,
        .card-body .col:last-child { 
            color: #ffffff !important; 
            font-weight: 700 !important;
            text-shadow: 1px 1px 3px rgba(0, 0, 0, 1) !important;
        }
        
        /* Navbar */
        .navbar { background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%) !important; border-bottom: 3px solid #FF8C00 !important; min-height: 80px !important; }
        .navbar-logo { height: 70px !important; filter: drop-shadow(0 0 10px rgba(255, 140, 0, 0.5)); }
        .navbar .nav-link { color: #FFD700 !important; font-weight: 600 !important; transition: all 0.3s; }
        .navbar .nav-link:hover { color: #FF8C00 !important; transform: translateY(-2px); }
        .navbar .nav-link i { color: #FF8C00 !important; }
        
        /* Cards */
        .card { background: #1a1a1a !important; border: 2px solid rgba(255, 140, 0, 0.3) !important; }
        .card-body { background: #1a1a1a !important; }
        .card-header { background: linear-gradient(135deg, rgba(255, 140, 0, 0.3), rgba(255, 215, 0, 0.3)) !important; color: #FFD700 !important; border-bottom: 2px solid #FF8C00 !important; }
        
        /* Textos */
        h1, h2, h3, h4, h5, h6 { color: #FFD700 !important; font-weight: 800 !important; text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.8); }
        label, .form-label { color: #FFD700 !important; font-weight: 600 !important; }
        p, span, small, .text-muted { color: #e0e0e0 !important; }
        strong { color: #FFD700 !important; }
        
        /* Tablas */
        .table { background: #1a1a1a !important; }
        .table thead th { background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%) !important; color: #FFD700 !important; border-bottom: 2px solid #FF8C00 !important; }
        .table tbody tr { background: #1a1a1a !important; }
        .table tbody tr:nth-child(even) { background: #2d2d2d !important; }
        .table tbody tr:hover { background: rgba(255, 140, 0, 0.3) !important; }
        .table tbody td { color: #ffffff !important; }
        
        /* Alertas */
        .alert { background: rgba(26, 26, 26, 0.9) !important; border: 2px solid rgba(255, 140, 0, 0.3) !important; color: #fff !important; }
        
        /* Botones */
        .btn-primary { background: linear-gradient(135deg, #FF8C00, #FFD700) !important; border: none !important; color: #000 !important; font-weight: 700 !important; }
        .btn-secondary { background: #5a6268 !important; color: #fff !important; }
        .btn-success { background: linear-gradient(135deg, #28a745, #20c997) !important; border: none !important; }
        .btn-warning { background: linear-gradient(135deg, #ffc107, #FF8C00) !important; border: none !important; color: #000 !important; }
        .btn-danger { background: linear-gradient(135deg, #dc3545, #c82333) !important; border: none !important; }
        .btn-info { background: linear-gradient(135deg, #17a2b8, #138496) !important; border: none !important; }
        .badge { font-weight: 700 !important; }
        
        /* Tarjetas de estadísticas */
        .stat-card {
            background: linear-gradient(135deg, rgba(255, 140, 0, 0.2), rgba(255, 215, 0, 0.2)) !important;
            border: 2px solid rgba(255, 140, 0, 0.4) !important;
            transition: transform 0.2s;
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(255, 140, 0, 0.4) !important;
        }
        
        /* Forzar fondo oscuro en TODOS los elementos */
        * { background-color: transparent !important; }
        body * { background-color: transparent !important; }
        
        /* Excepciones que SÍ deben tener fondo */
        body, html { background-color: #0a0a0a !important; }
        .card { background-color: #1a1a1a !important; }
        .card-body { background-color: #1a1a1a !important; }
        .card-header { background: linear-gradient(135deg, rgba(255, 140, 0, 0.3), rgba(255, 215, 0, 0.3)) !important; }
        .navbar { background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%) !important; }
        .form-control, .form-select, textarea { background-color: rgba(45, 45, 45, 0.8) !important; }
        .btn { background: inherit !important; }
        .table thead th { background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%) !important; }
        .table tbody tr { background-color: #1a1a1a !important; }
        .table tbody tr:nth-child(even) { background-color: #2d2d2d !important; }
        .badge { background: inherit !important; }
        .alert { background-color: rgba(26, 26, 26, 0.9) !important; }
        .stat-card { background: linear-gradient(135deg, rgba(255, 140, 0, 0.2), rgba(255, 215, 0, 0.2)) !important; }
        
        /* Forzar color de texto en todo */
        .row, .col, div[class*="col-"] { color: #e0e0e0 !important; }
        
        /* DL (Definition List) para información - Mejorado y MUY VISIBLE */
        dl, dt, dd { color: #ffffff !important; font-size: 1.2em !important; }
        dt { 
            color: #FFD700 !important; 
            font-weight: 900 !important; 
            font-size: 1.3em !important; 
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 1) !important;
        }
        dd { 
            color: #ffffff !important; 
            font-weight: 700 !important;
            text-shadow: 1px 1px 3px rgba(0, 0, 0, 1) !important;
        }
        
        /* LABELS Y TÍTULOS MUY BRILLANTES */
        .card-body strong:first-child,
        .row > div > strong,
        .col strong {
            color: #FFD700 !important;
            font-weight: 900 !important;
            font-size: 1.2em !important;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 1), 0 0 10px rgba(255, 215, 0, 0.5) !important;
        }
        
        /* Cambiar cuadro azul a estilo CAYEJERO */
        .bg-primary, .bg-info, .text-bg-primary, .text-bg-info {
            background: linear-gradient(135deg, #FF8C00, #FFD700) !important;
            color: #000000 !important;
            border: 2px solid #FF8C00 !important;
        }
        
        /* Números grandes en tarjetas */
        .display-1, .display-2, .display-3, .display-4 {
            color: #FFD700 !important;
            font-weight: 900 !important;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.9);
        }
        
        /* Mejorar TODOS los textos con efecto gaming */
        .card-body p, .card-body span, .card-body div {
            color: #ffffff !important;
            font-weight: 700 !important;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.8) !important;
        }
        
        /* Etiquetas y labels más visibles - CAYEJERO */
        .text-muted {
            color: #FFD700 !important;
            font-weight: 800 !important;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.9) !important;
        }
        
        /* Forzar estilos en cards */
        .card .row div {
            color: #ffffff !important;
            font-weight: 700 !important;
        }
        
        /* IDs y valores importantes */
        .card strong, .card b {
            color: #FFD700 !important;
            font-weight: 900 !important;
            text-shadow: 2px 2px 3px rgba(0, 0, 0, 0.9) !important;
        }
        
        /* Todos los textos dentro de cards con más contraste */
        .card * {
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.8) !important;
        }
        
        /* Timeline */
        .timeline {
            position: relative;
            background: transparent !important;
        }
        .timeline::before {
            content: '';
            position: absolute;
            left: 30px;
            top: 0;
            bottom: 0;
            width: 2px;
            background: #dee2e6;
        }
        .timeline-item {
            position: relative;
            margin-bottom: 2rem;
            padding-left: 70px;
        }
        .timeline-icon {
            position: absolute;
            left: 0;
            top: 0;
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            background: white;
            border: 3px solid #dee2e6;
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <?php include __DIR__ . '/../partials/navbar-simple.php'; ?>
    
    <div class="container-fluid py-4">
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2><i class="fas fa-info-circle text-primary"></i> Detalles del Utensilio</h2>
            <div class="btn-group" role="group">
                <a href="/app-web-Enciso/public/inventario/editar?id=<?php echo $utensilio_id; ?>" class="btn btn-warning">
                    <i class="fas fa-edit"></i> Editar
                </a>
                <a href="/app-web-Enciso/public/inventario/movimiento?id=<?php echo $utensilio_id; ?>" class="btn btn-info">
                    <i class="fas fa-exchange-alt"></i> Movimiento
                </a>
                <a href="/app-web-Enciso/public/inventario" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Volver
                </a>
            </div>
        </div>

        <?php if (isset($error)): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-triangle"></i> <?php echo htmlspecialchars($error); ?>
            </div>
        <?php endif; ?>

        <div class="row">
            <!-- Información principal -->
            <div class="col-md-8">
                <!-- Datos del utensilio -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-utensils"></i> <?php echo htmlspecialchars($utensilio['nombre']); ?></h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-borderless">
                                    <tr>
                                        <th width="40%">ID:</th>
                                        <td><?php echo $utensilio['id']; ?></td>
                                    </tr>
                                    <tr>
                                        <th>Nombre:</th>
                                        <td><?php echo htmlspecialchars($utensilio['nombre']); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Categoría:</th>
                                        <td>
                                            <span class="badge bg-secondary"><?php echo htmlspecialchars($utensilio['categoria']); ?></span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Estado:</th>
                                        <td>
                                            <span class="badge bg-<?php echo $utensilio['estado'] === 'disponible' ? 'success' : 'warning'; ?>">
                                                <?php 
                                                echo $utensilio['estado'] === 'disponible' ? 'Disponible' : 
                                                    ($utensilio['estado'] === 'mantenimiento' ? 'En Reparación' : ucfirst($utensilio['estado'])); 
                                                ?>
                                            </span>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-borderless">
                                    <tr>
                                        <th width="40%">Ubicación:</th>
                                        <td><?php echo htmlspecialchars($utensilio['ubicacion'] ?: 'No especificada'); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Fecha de Registro:</th>
                                        <td><?php echo date('d/m/Y H:i', strtotime($utensilio['fecha_registro'])); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Última Actualización:</th>
                                        <td><?php echo date('d/m/Y H:i', strtotime($utensilio['fecha_actualizacion'])); ?></td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                        
                        <?php if ($utensilio['descripcion']): ?>
                            <div class="mt-3">
                                <h6>Descripción:</h6>
                                <p class="text-muted"><?php echo nl2br(htmlspecialchars($utensilio['descripcion'])); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Estadísticas de movimientos -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="fas fa-chart-bar"></i> Estadísticas de Movimientos</h6>
                    </div>
                    <div class="card-body">
                        <div class="row text-center">
                            <div class="col-md-4">
                                <div class="card stat-card border-0 bg-light">
                                    <div class="card-body py-3">
                                        <div class="text-primary">
                                            <i class="fas fa-list-ol fa-2x"></i>
                                        </div>
                                        <h4 class="mt-2 mb-1"><?php echo $estadisticas['total_movimientos'] ?? 0; ?></h4>
                                        <small class="text-muted">Total Movimientos</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card stat-card border-0 bg-light">
                                    <div class="card-body py-3">
                                        <div class="text-success">
                                            <i class="fas fa-arrow-down fa-2x"></i>
                                        </div>
                                        <h4 class="mt-2 mb-1"><?php echo $estadisticas['total_entradas'] ?? 0; ?></h4>
                                        <small class="text-muted">Entradas</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card stat-card border-0 bg-light">
                                    <div class="card-body py-3">
                                        <div class="text-danger">
                                            <i class="fas fa-arrow-up fa-2x"></i>
                                        </div>
                                        <h4 class="mt-2 mb-1"><?php echo $estadisticas['total_salidas'] ?? 0; ?></h4>
                                        <small class="text-muted">Salidas</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Panel lateral -->
            <div class="col-md-4">
                <!-- Estado actual -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="fas fa-tachometer-alt"></i> Estado Actual</h6>
                    </div>
                    <div class="card-body text-center">
                        <div class="row">
                            <div class="col-12">
                                <div class="bg-primary text-white rounded p-4">
                                    <h2 class="mb-1"><?php echo $utensilio['cantidad_total']; ?></h2>
                                    <small>Cantidad Total en Inventario</small>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Información adicional -->
                        <div class="mt-3">
                            <small class="text-muted">Estado: <?php echo ucfirst($utensilio['estado']); ?></small>
                        </div>
                    </div>
                </div>

                <!-- Acciones rápidas -->
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="fas fa-bolt"></i> Acciones Rápidas</h6>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <a href="/app-web-Enciso/public/inventario/movimiento?id=<?php echo $utensilio_id; ?>" 
                               class="btn btn-info btn-sm">
                                <i class="fas fa-exchange-alt"></i> Registrar Movimiento
                            </a>
                            <a href="/app-web-Enciso/public/inventario/editar?id=<?php echo $utensilio_id; ?>" 
                               class="btn btn-warning btn-sm">
                                <i class="fas fa-edit"></i> Editar Información
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Historial de movimientos -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-history"></i> Historial de Movimientos</h5>
                    </div>
                    <div class="card-body">
                        <?php if (empty($movimientos)): ?>
                            <div class="text-center text-muted py-5">
                                <i class="fas fa-inbox fa-3x mb-3"></i>
                                <h5>No hay movimientos registrados</h5>
                                <p>Cuando se registren movimientos aparecerán aquí</p>
                            </div>
                        <?php else: ?>
                            <div class="timeline">
                                <?php foreach ($movimientos as $mov): ?>
                                    <div class="timeline-item">
                                        <div class="timeline-icon border-<?php echo str_replace('bg-', '', getBadgeClass($mov['tipo_movimiento'])); ?>">
                                            <i class="<?php echo getMovementIcon($mov['tipo_movimiento']); ?>"></i>
                                        </div>
                                        <div class="card border-0 shadow-sm">
                                            <div class="card-body py-3">
                                                <div class="d-flex justify-content-between align-items-start mb-2">
                                                    <div>
                                                        <span class="badge <?php echo getBadgeClass($mov['tipo_movimiento']); ?> me-2">
                                                            <?php echo ucfirst($mov['tipo_movimiento']); ?>
                                                        </span>
                                                        <strong>Cantidad: <?php echo $mov['cantidad']; ?></strong>
                                                    </div>
                                                    <small class="text-muted">
                                                        <?php echo date('d/m/Y H:i', strtotime($mov['fecha_movimiento'])); ?>
                                                    </small>
                                                </div>
                                                
                                                <?php if ($mov['motivo']): ?>
                                                    <p class="mb-1 text-muted">
                                                        <i class="fas fa-comment-alt me-1"></i>
                                                        <?php echo htmlspecialchars($mov['motivo']); ?>
                                                    </p>
                                                <?php endif; ?>
                                                
                                                <?php if ($mov['usuario_nombre']): ?>
                                                    <small class="text-muted">
                                                        <i class="fas fa-user me-1"></i>
                                                        Registrado por: <?php echo htmlspecialchars($mov['usuario_nombre']); ?>
                                                    </small>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>


