<?php
/**
 * PÁGINA PARA EDITAR UTENSILIO EXISTENTE
 */

// Verificar autenticación
if (!isset($_SESSION['usuario_id'])) {
    header('Location: /app-web-Enciso/public/login');
    exit;
}

// Obtener ID del utensilio
$utensilio_id = $_GET['id'] ?? null;
if (!$utensilio_id) {
    $_SESSION['error'] = 'ID de utensilio no válido';
    header('Location: /app-web-Enciso/public/inventario');
    exit;
}

try {
    $pdo = new PDO("mysql:host=localhost;dbname=server_inventario_utensilios;charset=utf8mb4", 'server_admin', 'Admin2025!');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Obtener datos del utensilio
    $stmt = $pdo->prepare("SELECT * FROM utensilios WHERE id = ?");
    $stmt->execute([$utensilio_id]);
    $utensilio = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$utensilio) {
        $_SESSION['error'] = 'Utensilio no encontrado';
        header('Location: /app-web-Enciso/public/inventario');
        exit;
    }
    
    // Procesar formulario si es POST
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $nombre = $_POST['nombre'] ?? '';
        $descripcion = $_POST['descripcion'] ?? '';
        $categoria = $_POST['categoria'] ?? '';
        $ubicacion = $_POST['ubicacion'] ?? '';
        $cantidad_minima = (int)($_POST['cantidad_minima'] ?? 1);
        $estado = $_POST['estado'] ?? '1';
        
        if (empty($nombre) || empty($categoria) || $cantidad_minima <= 0) {
            throw new Exception('Por favor complete todos los campos requeridos y el stock mínimo debe ser mayor a 0');
        }
        
        // Actualizar información del utensilio (NO cantidades de inventario)
        $stmt = $pdo->prepare("UPDATE utensilios SET nombre = ?, descripcion = ?, categoria = ?, ubicacion = ?, cantidad_minima = ?, estado = ? WHERE id = ?");
        $stmt->execute([$nombre, $descripcion, $categoria, $ubicacion, $cantidad_minima, $estado, $utensilio_id]);
        
        $_SESSION['success'] = 'Información del utensilio actualizada exitosamente (para cambiar cantidades use "Ajustar Stock")';
        header('Location: /app-web-Enciso/public/inventario');
        exit;
    }
    
} catch (Exception $e) {
    $error = $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Utensilio - Sistema CAYEJERO</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="../../assets/css/dashboard.css?v=20251210003" rel="stylesheet">
    <link href="../../assets/css/utensilios.css?v=20251210003" rel="stylesheet">
    <link href="../../assets/css/form-utensilio.css?v=20251210003" rel="stylesheet">
    <style>
        /* CAYEJERO - Forzar tema oscuro */
        body, html { background: #0a0a0a !important; }
        .container-fluid { background: #0a0a0a !important; }
        
        /* Navbar */
        .navbar { background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%) !important; border-bottom: 3px solid #FF8C00 !important; min-height: 80px !important; }
        .navbar-logo { height: 70px !important; filter: drop-shadow(0 0 10px rgba(255, 140, 0, 0.5)); }
        .navbar .nav-link { color: #FFD700 !important; font-weight: 600 !important; transition: all 0.3s; }
        .navbar .nav-link:hover { color: #FF8C00 !important; transform: translateY(-2px); }
        .navbar .nav-link i { color: #FF8C00 !important; }
        
        /* Cards */
        .card { background: #1a1a1a !important; border: 2px solid rgba(255, 140, 0, 0.3) !important; }
        .card-body { background: #1a1a1a !important; }
        .card-header { background: linear-gradient(135deg, rgba(255, 140, 0, 0.3), rgba(255, 215, 0, 0.3)) !important; color: #FFD700 !important; border-bottom: 2px solid #FF8C00 !important; }
        
        /* Textos */
        h1, h2, h3, h4, h5, h6 { color: #FFD700 !important; font-weight: 800 !important; text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.8); }
        label, .form-label { color: #FFD700 !important; font-weight: 600 !important; }
        p, span, small, .text-muted { color: #e0e0e0 !important; }
        
        /* Formularios */
        .form-control, .form-select { background: rgba(45, 45, 45, 0.8) !important; border: 2px solid rgba(255, 140, 0, 0.4) !important; color: #fff !important; }
        .form-control:focus, .form-select:focus { background: rgba(255, 140, 0, 0.15) !important; border-color: #FF8C00 !important; color: #fff !important; }
        
        /* Opciones del select */
        select option { background: #1a1a1a !important; color: #FFD700 !important; font-weight: 600; }
        select option:checked { background: #FF8C00 !important; color: #000 !important; }
        
        /* Alertas */
        .alert { background: rgba(26, 26, 26, 0.9) !important; border: 2px solid rgba(255, 140, 0, 0.3) !important; color: #fff !important; }
        
        /* Botones */
        .btn-primary { background: linear-gradient(135deg, #FF8C00, #FFD700) !important; border: none !important; color: #000 !important; font-weight: 700 !important; }
        .btn-secondary { background: #5a6268 !important; color: #fff !important; }
        .badge { background: linear-gradient(135deg, #0d6efd, #0a58ca) !important; }
    </style>
</head>
<body>
    <!-- Navbar -->
    <?php include __DIR__ . '/../partials/navbar-simple.php'; ?>
    
    <div class="container-fluid py-4">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <!-- Header -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <div>
                        <h2><i class="fas fa-edit text-warning"></i> Editar Información del Utensilio</h2>
                        <small class="text-muted">
                            <i class="fas fa-info-circle"></i> 
                            Esta página permite editar la información del utensilio. Para cambiar cantidades use "Ajustar Stock".
                        </small>
                    </div>
                    <div class="btn-group">
                        <a href="/app-web-Enciso/public/inventario/ajustar-stock?id=<?php echo $utensilio_id; ?>" class="btn btn-primary">
                            <i class="fas fa-calculator"></i> Ajustar Stock
                        </a>
                        <a href="/app-web-Enciso/public/inventario" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Volver
                        </a>
                    </div>
                </div>

                <!-- Mensajes -->
                <?php if (isset($error)): ?>
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-triangle"></i> <?php echo htmlspecialchars($error); ?>
                    </div>
                <?php endif; ?>

                <!-- Información actual -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="fas fa-info-circle"></i> Estado Actual del Inventario</h6>
                    </div>
                    <div class="card-body">
                        <div class="row text-center">
                            <div class="col-md-12">
                                <div class="badge bg-primary fs-6">Cantidad Total: <?php echo $utensilio['cantidad_total']; ?></div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Formulario -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-utensils"></i> Información del Utensilio</h5>
                    </div>
                    <div class="card-body">
                        <form method="POST">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="nombre" class="form-label">Nombre *</label>
                                    <input type="text" class="form-control" id="nombre" name="nombre" 
                                           value="<?php echo htmlspecialchars($_POST['nombre'] ?? $utensilio['nombre']); ?>" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="categoria" class="form-label">Categoría *</label>
                                    <select class="form-control" id="categoria" name="categoria" required>
                                        <option value="">Seleccione una categoría</option>
                                        <option value="Cubiertos" <?php echo ($_POST['categoria'] ?? $utensilio['categoria']) === 'Cubiertos' ? 'selected' : ''; ?>>Cubiertos</option>
                                        <option value="Platos" <?php echo ($_POST['categoria'] ?? $utensilio['categoria']) === 'Platos' ? 'selected' : ''; ?>>Platos</option>
                                        <option value="Vasos" <?php echo ($_POST['categoria'] ?? $utensilio['categoria']) === 'Vasos' ? 'selected' : ''; ?>>Vasos</option>
                                        <option value="Jarras" <?php echo ($_POST['categoria'] ?? $utensilio['categoria']) === 'Jarras' ? 'selected' : ''; ?>>Jarras</option>
                                        <option value="Cocina" <?php echo ($_POST['categoria'] ?? $utensilio['categoria']) === 'Cocina' ? 'selected' : ''; ?>>Cocina</option>
                                        <option value="Otros" <?php echo ($_POST['categoria'] ?? $utensilio['categoria']) === 'Otros' ? 'selected' : ''; ?>>Otros</option>
                                    </select>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="descripcion" class="form-label">Descripción</label>
                                <textarea class="form-control" id="descripcion" name="descripcion" rows="3" 
                                          placeholder="Descripción detallada del utensilio..."><?php echo htmlspecialchars($_POST['descripcion'] ?? $utensilio['descripcion']); ?></textarea>
                            </div>

                            <div class="row">
                                <div class="col-md-4 mb-3">
                                    <label for="cantidad_minima" class="form-label">
                                        <i class="fas fa-exclamation-triangle text-warning"></i> Stock Mínimo *
                                    </label>
                                    <input type="number" class="form-control" id="cantidad_minima" name="cantidad_minima" 
                                           value="<?php echo htmlspecialchars($_POST['cantidad_minima'] ?? $utensilio['cantidad_minima'] ?? 5); ?>" min="1" required>
                                    <div class="form-text">Cantidad que activará alertas de stock bajo</div>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="ubicacion" class="form-label">Ubicación</label>
                                    <select class="form-control" id="ubicacion" name="ubicacion">
                                        <option value="">Seleccione ubicación</option>
                                        <option value="Cajón de Cubiertos - Comedor" <?php echo ($_POST['ubicacion'] ?? $utensilio['ubicacion']) === 'Cajón de Cubiertos - Comedor' ? 'selected' : ''; ?>>Cajón de Cubiertos - Comedor</option>
                                        <option value="Estantería de Vajilla - Comedor" <?php echo ($_POST['ubicacion'] ?? $utensilio['ubicacion']) === 'Estantería de Vajilla - Comedor' ? 'selected' : ''; ?>>Estantería de Vajilla - Comedor</option>
                                        <option value="Estantería de Cristalería - Bar" <?php echo ($_POST['ubicacion'] ?? $utensilio['ubicacion']) === 'Estantería de Cristalería - Bar' ? 'selected' : ''; ?>>Estantería de Cristalería - Bar</option>
                                        <option value="Área de Preparación - Cocina" <?php echo ($_POST['ubicacion'] ?? $utensilio['ubicacion']) === 'Área de Preparación - Cocina' ? 'selected' : ''; ?>>Área de Preparación - Cocina</option>
                                        <option value="Almacén General" <?php echo ($_POST['ubicacion'] ?? $utensilio['ubicacion']) === 'Almacén General' ? 'selected' : ''; ?>>Almacén General</option>
                                    </select>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="estado" class="form-label">Estado del Utensilio</label>
                                    <select class="form-control" id="estado" name="estado">
                                        <option value="disponible" <?php echo ($_POST['estado'] ?? $utensilio['estado']) === 'disponible' ? 'selected' : ''; ?>>Disponible</option>
                                        <option value="mantenimiento" <?php echo ($_POST['estado'] ?? $utensilio['estado']) === 'mantenimiento' ? 'selected' : ''; ?>>En Reparación</option>
                                    </select>
                                    <div class="form-text">Solo para utensilios rotos o en reparación</div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12">
                                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                        <a href="/app-web-Enciso/public/inventario" class="btn btn-secondary me-md-2">
                                            <i class="fas fa-times"></i> Cancelar
                                        </a>
                                        <button type="submit" class="btn btn-warning">
                                            <i class="fas fa-save"></i> Guardar Información
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>


