<?php
/**
 * PÁGINA DE INVENTARIO
 */

// Verificar autenticación (ya verificada en router, pero por seguridad)
if (!isset($_SESSION['usuario_id'])) {
    header('Location: /app-web-Enciso/public/login');
    exit;
}

# Obtener parámetros de filtro
$buscar = $_GET['buscar'] ?? '';
$categoria_filtro = $_GET['categoria'] ?? '';

// Obtener datos del inventario con filtros
try {
    $pdo = new PDO("mysql:host=localhost;dbname=server_inventario_utensilios;charset=utf8mb4", 'server_admin', 'Admin2025!');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Construir consulta con filtros
    $sql = "SELECT * FROM utensilios WHERE activo = 1";
    $params = [];
    
    if (!empty($buscar)) {
        $sql .= " AND (nombre LIKE ? OR descripcion LIKE ?)";
        $params[] = "%$buscar%";
        $params[] = "%$buscar%";
    }
    
    if (!empty($categoria_filtro)) {
        $sql .= " AND categoria = ?";
        $params[] = $categoria_filtro;
    }
    
    $sql .= " ORDER BY categoria, nombre";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $utensilios = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Obtener categorías únicas para el select
    $stmt = $pdo->query("SELECT DISTINCT categoria FROM utensilios WHERE activo = 1 ORDER BY categoria");
    $categorias = $stmt->fetchAll(PDO::FETCH_COLUMN);
    

    
} catch (Exception $e) {
    $utensilios = [];
    $categorias = [];
}

// Función para resaltar términos de búsqueda
function highlightSearch($text, $search) {
    if (empty($search) || empty($text)) return htmlspecialchars($text);
    
    $highlighted = preg_replace('/(' . preg_quote($search, '/') . ')/i', '<span class="search-highlight">$1</span>', htmlspecialchars($text));
    return $highlighted;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inventario - Sistema CAYEJERO</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        /* === ESTILOS CAYEJERO INVENTARIO === */
        body {
            background: linear-gradient(135deg, #0a0a0a, #1a1a1a) !important;
            color: #ffffff !important;
            min-height: 100vh;
        }
        
        h1, h2, h3, h4, h5, h6 {
            color: #FFD700 !important;
            font-weight: 800 !important;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.8);
        }
        
        .card {
            background: linear-gradient(135deg, #1a1a1a, #2a2a2a) !important;
            border: 2px solid rgba(255, 140, 0, 0.3) !important;
            border-radius: 15px !important;
            color: #ffffff !important;
        }
        
        .form-control, .form-select {
            background-color: rgba(42, 42, 42, 0.8) !important;
            border: 2px solid rgba(255, 140, 0, 0.3) !important;
            color: #ffffff !important;
            font-weight: 500;
        }
        
        .form-control:focus, .form-select:focus {
            background-color: rgba(42, 42, 42, 0.9) !important;
            border-color: #FFD700 !important;
            box-shadow: 0 0 10px rgba(255, 215, 0, 0.3) !important;
            color: #ffffff !important;
        }
        
        .form-control::placeholder {
            color: #999999;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #007bff, #0056b3) !important;
            border: none !important;
            color: #ffffff !important;
            font-weight: 700 !important;
            transition: all 0.3s ease !important;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 123, 255, 0.4) !important;
        }
        
        .btn-success {
            background: linear-gradient(135deg, #28a745, #1e7e34) !important;
            border: none !important;
            font-weight: 700 !important;
        }
        
        .btn-warning {
            background: linear-gradient(135deg, #ffc107, #e0a800) !important;
            border: none !important;
            font-weight: 700 !important;
            color: #000000 !important;
        }
        
        .btn-danger {
            background: linear-gradient(135deg, #dc3545, #bd2130) !important;
            border: none !important;
            font-weight: 700 !important;
        }
        
        .btn-info {
            background: linear-gradient(135deg, #17a2b8, #0d7488) !important;
            border: none !important;
            font-weight: 700 !important;
        }
        
        .table {
            background: transparent !important;
            color: #ffffff !important;
        }
        
        .table thead th {
            background: linear-gradient(135deg, rgba(255, 140, 0, 0.3), rgba(255, 215, 0, 0.2)) !important;
            border-color: rgba(255, 140, 0, 0.5) !important;
            color: #FFD700 !important;
            font-weight: 800 !important;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .table tbody tr {
            border-color: rgba(255, 140, 0, 0.2) !important;
            transition: all 0.3s ease;
        }
        
        .table tbody tr:hover {
            background: rgba(255, 140, 0, 0.1) !important;
        }
        
        .table tbody td {
            color: #ffffff !important;
            font-weight: 500;
            vertical-align: middle;
        }
        
        .badge {
            font-weight: 700;
            padding: 0.5rem 0.8rem;
            border-radius: 8px;
        }
        
        .badge.bg-secondary {
            background: linear-gradient(135deg, #6c757d, #545b62) !important;
        }
        
        .badge.bg-success {
            background: linear-gradient(135deg, #28a745, #1e7e34) !important;
        }
        
        .badge.bg-warning {
            background: linear-gradient(135deg, #ffc107, #e0a800) !important;
            color: #000000 !important;
        }
        
        .badge.bg-danger {
            background: linear-gradient(135deg, #dc3545, #bd2130) !important;
        }
        
        .text-muted {
            color: #cccccc !important;
        }
        
        small {
            color: #cccccc !important;
        }
        
        .alert {
            border-radius: 10px;
            border: 2px solid;
            font-weight: 600;
        }
        
        .alert-info {
            background: rgba(23, 162, 184, 0.2) !important;
            border-color: #17a2b8 !important;
            color: #ffffff !important;
        }
        
        .btn-group .btn {
            margin: 0 2px;
        }
        
        /* Estilos para los iconos de estado */
        .fa-check-circle {
            color: #28a745 !important;
        }
        
        .fa-exclamation-triangle {
            color: #ffc107 !important;
        }
        
        .fa-times-circle {
            color: #dc3545 !important;
        }
        
        /* Estilos específicos para nombres y descripciones */
        .table tbody td:first-child {
            color: #FFD700 !important;
            font-weight: 700 !important;
        }
        
        .table tbody td strong {
            color: #FFD700 !important;
        }
        
        .table tbody td small,
        .table tbody td .text-muted {
            color: #999999 !important;
            display: block;
            margin-top: 0.25rem;
        }
        
        /* Asegurar que todo el texto de la tabla sea visible */
        .table tbody td * {
            color: inherit;
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <?php include __DIR__ . '/../partials/navbar-simple.php'; ?>
    
    <div class="container-fluid py-4">
            <!-- Contenido Principal -->
            <main class="col-12">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2"><i class="fas fa-boxes"></i> Gestión de Inventario</h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <a href="/app-web-Enciso/public/inventario/agregar" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Agregar Utensilio
                        </a>
                    </div>
                </div>

                <!-- Estadísticas de Alertas -->
                <?php
                // Calcular estadísticas de alertas
                $total_items = count($utensilios);
                $items_agotados = 0;
                $items_stock_bajo = 0;
                $items_ok = 0;

                foreach ($utensilios as $utensilio) {
                    $stock_minimo = $utensilio['cantidad_minima'] ?? 5;
                    $total = $utensilio['cantidad_total'];
                    
                    if ($total == 0) {
                        $items_agotados++;
                    } elseif ($total <= $stock_minimo) {
                        $items_stock_bajo++;
                    } else {
                        $items_ok++;
                    }
                }
                
                $tiene_alertas = ($items_agotados > 0 || $items_stock_bajo > 0);
                ?>
                
                <?php if ($tiene_alertas): ?>
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="alert alert-warning border-0 shadow-sm">
                            <div class="d-flex align-items-center justify-content-between flex-wrap">
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-exclamation-triangle fa-lg me-3"></i>
                                    <div>
                                        <h6 class="alert-heading mb-1">
                                            <strong>⚠️ Alertas de Inventario Detectadas</strong>
                                        </h6>
                                        <div class="d-flex gap-4 flex-wrap">
                                            <?php if ($items_agotados > 0): ?>
                                                <span class="text-danger fw-bold">
                                                    <i class="fas fa-times-circle"></i> 
                                                    <?php echo $items_agotados; ?> agotado<?php echo $items_agotados > 1 ? 's' : ''; ?>
                                                </span>
                                            <?php endif; ?>
                                            
                                            <?php if ($items_stock_bajo > 0): ?>
                                                <span class="text-warning fw-bold">
                                                    <i class="fas fa-exclamation-triangle"></i> 
                                                    <?php echo $items_stock_bajo; ?> con stock bajo
                                                </span>
                                            <?php endif; ?>
                                            
                                            <span class="text-success">
                                                <i class="fas fa-check-circle"></i> 
                                                <?php echo $items_ok; ?> en buen stock
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-2 mt-md-0">
                                    <a href="/app-web-Enciso/public/reportes" class="btn btn-warning btn-sm">
                                        <i class="fas fa-chart-line"></i> Ver Reportes
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Filtros -->
                <div class="filter-section">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h6 class="mb-0">
                            <i class="fas fa-filter text-primary me-2"></i>
                            Filtros de Búsqueda
                        </h6>
                        <small class="text-muted">
                            <i class="fas fa-info-circle me-1"></i>
                            Escriba en la búsqueda y presione <kbd>Enter</kbd> • Los selectores filtran automáticamente
                        </small>
                    </div>
                
                <form method="GET" action="/app-web-Enciso/public/inventario">
                    <div class="row">
                        <div class="col-md-5">
                            <div class="input-group">
                                <span class="input-group-text">
                                    <i class="fas fa-search"></i>
                                </span>
                                <input type="text" 
                                       name="buscar" 
                                       class="form-control" 
                                       placeholder="Buscar utensilio por nombre o descripción..."
                                       value="<?php echo htmlspecialchars($buscar); ?>"
                                       title="Presione Enter o haga clic en Filtrar para buscar">
                                <span class="input-group-text bg-light">
                                    <small class="text-muted">↵</small>
                                </span>
                            </div>
                            <div class="form-text">
                                💡 <small>Escriba el término y presione <kbd>Enter</kbd> o haga clic en <strong>Filtrar</strong></small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <select name="categoria" class="form-control" onchange="this.form.submit()">
                                <option value="">Todas las categorías</option>
                                <?php foreach ($categorias as $categoria): ?>
                                    <option value="<?php echo htmlspecialchars($categoria); ?>"
                                            <?php echo ($categoria_filtro === $categoria) ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($categoria); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <div class="btn-group w-100">
                                <button type="submit" class="btn btn-primary btn-filter" title="Aplicar filtros">
                                    <i class="fas fa-filter"></i> Filtrar
                                </button>
                                <a href="/app-web-Enciso/public/inventario" class="btn btn-outline-secondary" title="Limpiar filtros">
                                    <i class="fas fa-times"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Filtros Rápidos de Alertas -->
                    <?php if ($tiene_alertas): ?>
                    <div class="row mt-3">
                        <div class="col-12">
                            <div class="alert alert-light border py-2">
                                <small class="text-muted me-3">
                                    <i class="fas fa-bolt"></i> <strong>Filtros Rápidos:</strong>
                                </small>
                                <div class="btn-group btn-group-sm" role="group">
                                    <button type="button" class="btn btn-outline-danger" onclick="filtrarPorStock('agotado')">
                                        <i class="fas fa-times-circle"></i> Stock Agotado (<?php echo $items_agotados; ?>)
                                    </button>
                                    <button type="button" class="btn btn-outline-warning" onclick="filtrarPorStock('bajo')">
                                        <i class="fas fa-exclamation-triangle"></i> Stock Bajo (<?php echo $items_stock_bajo; ?>)
                                    </button>
                                    <button type="button" class="btn btn-outline-success" onclick="filtrarPorStock('ok')">
                                        <i class="fas fa-check-circle"></i> Stock OK (<?php echo $items_ok; ?>)
                                    </button>
                                    <button type="button" class="btn btn-outline-secondary" onclick="filtrarPorStock('todos')">
                                        <i class="fas fa-list"></i> Ver Todos
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                        </div>
                    </div>
                </form>
                </div>

                <!-- Información de resultados -->
                <?php 
                $total_resultados = count($utensilios);
                $filtros_activos = [];
                if (!empty($buscar)) $filtros_activos[] = "Búsqueda: '$buscar'";
                if (!empty($categoria_filtro)) $filtros_activos[] = "Categoría: $categoria_filtro";
                ?>
                
                <div class="results-info">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <i class="fas fa-list-ul text-primary me-2"></i>
                            <strong>
                                <?php echo "Mostrando $total_resultados " . ($total_resultados == 1 ? 'utensilio' : 'utensilios'); ?>
                            </strong>
                            
                            <?php if (!empty($filtros_activos)): ?>
                                <div class="mt-1">
                                    <small class="text-muted">
                                        <i class="fas fa-filter me-1"></i>
                                        Filtros aplicados: 
                                        <?php foreach ($filtros_activos as $index => $filtro): ?>
                                            <?php if ($index > 0) echo " • "; ?>
                                            <span class="badge bg-light text-dark"><?php echo $filtro; ?></span>
                                        <?php endforeach; ?>
                                    </small>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <?php if (!empty($filtros_activos)): ?>
                            <a href="/app-web-Enciso/public/inventario" class="btn btn-sm btn-outline-primary">
                                <i class="fas fa-eraser"></i> Limpiar filtros
                            </a>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Tabla de Inventario -->
                <div class="card">
                    <div class="card-body">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Nombre</th>
                                    <th>Categoría</th>
                                    <th>Cantidad</th>
                                    <th>Ubicación</th>
                                    <th>Última Actualización</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($utensilios)): ?>
                                    <tr class="no-hover">
                                        <td colspan="7" class="text-center py-5">
                                            <?php if (!empty($buscar) || !empty($categoria_filtro)): ?>
                                                <!-- Sin resultados por filtros -->
                                                <i class="fas fa-search fa-3x text-muted mb-3"></i>
                                                <h5 class="text-muted">No se encontraron resultados</h5>
                                                <p class="text-muted mb-3">
                                                    No hay utensilios que coincidan con los filtros aplicados.
                                                </p>
                                                <div class="d-flex justify-content-center gap-2">
                                                    <a href="/app-web-Enciso/public/inventario" class="btn btn-outline-secondary">
                                                        <i class="fas fa-times"></i> Limpiar filtros
                                                    </a>
                                                    <a href="/app-web-Enciso/public/inventario/agregar" class="btn btn-primary">
                                                        <i class="fas fa-plus"></i> Agregar Utensilio
                                                    </a>
                                                </div>
                                            <?php else: ?>
                                                <!-- Sin utensilios en general -->
                                                <i class="fas fa-box-open fa-3x text-muted mb-3"></i>
                                                <h5 class="text-muted">Inventario vacío</h5>
                                                <p class="text-muted mb-3">No hay utensilios registrados aún</p>
                                                <div class="d-flex justify-content-center">
                                                    <a href="/app-web-Enciso/public/inventario/agregar" class="btn btn-primary">
                                                        <i class="fas fa-plus"></i> Agregar Primer Utensilio
                                                    </a>
                                                </div>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php else: ?>
                                    <?php foreach ($utensilios as $utensilio): ?>
                                        <?php 
                                        // Determinar clase de alerta para la fila
                                        $stock_minimo = $utensilio['cantidad_minima'] ?? 5;
                                        $tiene_stock_bajo = $utensilio['cantidad_total'] <= $stock_minimo;
                                        $stock_agotado = $utensilio['cantidad_total'] == 0;
                                        
                                        $row_class = '';
                                        if ($stock_agotado) {
                                            $row_class = 'row-stock-critical';
                                        } elseif ($tiene_stock_bajo) {
                                            $row_class = 'row-stock-warning';
                                        }
                                        ?>
                                        <tr class="<?php echo $row_class; ?>">
                                            <td>#<?php echo str_pad($utensilio['id'], 3, '0', STR_PAD_LEFT); ?></td>
                                            <td>
                                                <strong><?php echo highlightSearch($utensilio['nombre'], $buscar); ?></strong>
                                                <?php if (!empty($utensilio['descripcion'])): ?>
                                                    <br><small class="text-muted"><?php echo highlightSearch($utensilio['descripcion'], $buscar); ?></small>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <span class="badge bg-secondary"><?php echo htmlspecialchars($utensilio['categoria']); ?></span>
                                            </td>
                                            <td>
                                                <div class="d-flex flex-column">
                                                    <span><strong><?php echo $utensilio['cantidad_total']; ?></strong> unidades</span>
                                                    
                                                    <?php 
                                                    // Verificar alertas de stock
                                                    $stock_minimo = $utensilio['cantidad_minima'] ?? 5;
                                                    $tiene_stock_bajo = $utensilio['cantidad_total'] <= $stock_minimo;
                                                    $stock_agotado = $utensilio['cantidad_total'] == 0;
                                                    ?>
                                                    
                                                    <?php if ($stock_agotado): ?>
                                                        <small class="text-danger fw-bold">
                                                            <i class="fas fa-exclamation-circle"></i> 
                                                            AGOTADO
                                                        </small>
                                                    <?php elseif ($tiene_stock_bajo): ?>
                                                        <small class="text-warning fw-bold">
                                                            <i class="fas fa-exclamation-triangle"></i> 
                                                            STOCK BAJO
                                                        </small>
                                                    <?php else: ?>
                                                        <small class="text-success">
                                                            <i class="fas fa-check-circle"></i> 
                                                            Stock OK
                                                        </small>
                                                    <?php endif; ?>
                                                    
                                                    <small class="text-muted">Mínimo: <?php echo $stock_minimo; ?></small>
                                                </div>
                                            </td>
                                            <td>
                                                <small class="text-muted">
                                                    <i class="fas fa-map-marker-alt"></i>
                                                    <?php echo htmlspecialchars($utensilio['ubicacion']); ?>
                                                </small>
                                            </td>
                                            <td>
                                                <div class="d-flex flex-column">
                                                    <small><?php echo date('d/m/Y', strtotime($utensilio['fecha_actualizacion'])); ?></small>
                                                    <small class="text-muted"><?php echo date('H:i', strtotime($utensilio['fecha_actualizacion'])); ?></small>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <a href="/app-web-Enciso/public/inventario/editar?id=<?php echo $utensilio['id']; ?>" 
                                                       class="btn btn-outline-warning" title="Editar Información">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <a href="/app-web-Enciso/public/inventario/ajustar-stock?id=<?php echo $utensilio['id']; ?>" 
                                                       class="btn btn-outline-primary" title="Ajustar Stock">
                                                        <i class="fas fa-calculator"></i>
                                                    </a>
                                                    <a href="/app-web-Enciso/public/inventario/movimiento?id=<?php echo $utensilio['id']; ?>" 
                                                       class="btn btn-outline-info" title="Movimiento">
                                                        <i class="fas fa-exchange-alt"></i>
                                                    </a>
                                                    <a href="/app-web-Enciso/public/inventario/detalles?id=<?php echo $utensilio['id']; ?>" 
                                                       class="btn btn-outline-secondary" title="Ver Detalles">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </main>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Búsqueda en tiempo real con debounce (DESHABILITADA - solo manual)
        let searchTimeout;
        const searchInput = document.querySelector('input[name="buscar"]');
        
        if (searchInput) {
            // Búsqueda solo al presionar Enter o al hacer clic en Filtrar
            searchInput.addEventListener('keypress', function(e) {
                if (e.key === 'Enter') {
                    e.preventDefault();
                    this.form.submit();
                }
            });
            
            // Mantener focus después de cargar la página si hay búsqueda activa
            if (searchInput.value.trim() !== '') {
                searchInput.classList.add('border-primary');
                setTimeout(() => {
                    searchInput.focus();
                    // Posicionar cursor al final
                    const len = searchInput.value.length;
                    searchInput.setSelectionRange(len, len);
                }, 100);
            }
            
            // Agregar indicador visual cuando hay texto
            searchInput.addEventListener('input', function() {
                if (this.value.trim() !== '') {
                    this.classList.add('border-warning');
                    this.classList.remove('border-primary');
                } else {
                    this.classList.remove('border-warning', 'border-primary');
                }
            });
        }
        
        // Efecto hover en filas de la tabla
        document.querySelectorAll('tbody tr').forEach(row => {
            if (!row.querySelector('.text-center')) { // No aplicar a filas de "sin resultados"
                row.addEventListener('mouseenter', function() {
                    this.style.transform = 'scale(1.01)';
                    this.style.transition = 'transform 0.2s';
                });
                
                row.addEventListener('mouseleave', function() {
                    this.style.transform = 'scale(1)';
                });
            }
        });
        
        // Mostrar loading durante filtros
        document.querySelectorAll('select[name="categoria"], select[name="estado"]').forEach(select => {
            select.addEventListener('change', function() {
                // Mostrar indicador de carga
                const form = this.closest('form');
                const submitBtn = form.querySelector('button[type="submit"]');
                const originalText = submitBtn.innerHTML;
                
                submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Filtrando...';
                submitBtn.disabled = true;
                
                // Enviar formulario
                setTimeout(() => {
                    form.submit();
                }, 100);
            });
        });
        
        // Limpiar búsqueda con Escape
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape' && searchInput === document.activeElement) {
                searchInput.value = '';
                searchInput.form.submit();
            }
        });
        
        // Auto-focus en campo de búsqueda con Ctrl+F
        document.addEventListener('keydown', function(e) {
            if (e.ctrlKey && e.key === 'f') {
                e.preventDefault();
                searchInput.focus();
                searchInput.select();
            }
        });
        
        // Función para filtrar por estado de stock
        function filtrarPorStock(tipo) {
            const filas = document.querySelectorAll('tbody tr:not(.no-hover)');
            
            filas.forEach(fila => {
                const stockCell = fila.querySelector('td:nth-child(4)'); // Columna de cantidad
                const esVisible = determinarVisibilidadSegunStock(stockCell, tipo);
                
                fila.style.display = esVisible ? '' : 'none';
            });
            
            // Actualizar botones activos
            document.querySelectorAll('.btn-group-sm .btn').forEach(btn => {
                btn.classList.remove('active');
            });
            event.target.classList.add('active');
        }
        
        function determinarVisibilidadSegunStock(stockCell, tipo) {
            if (!stockCell) return false;
            
            const texto = stockCell.textContent;
            const tieneAgotado = texto.includes('AGOTADO');
            const tieneStockBajo = texto.includes('STOCK BAJO');
            const esStockOK = !tieneAgotado && !tieneStockBajo && texto.includes('disponibles');
            
            switch(tipo) {
                case 'agotado':
                    return tieneAgotado;
                case 'bajo':
                    return tieneStockBajo;
                case 'ok':
                    return esStockOK;
                case 'todos':
                default:
                    return true;
            }
        }
    </script>
</body>
</html>


