<?php
/**
 * Vista de detalle de movimiento
 */

require_once '../config/config.php';
require_once '../src/BLL/MovimientoService.php';
require_once '../src/BLL/AuthService.php';

$authService = new AuthService();
$movimientoService = new MovimientoService();

// Verificar autenticación
$authService->verificarSesion();

// Obtener ID del movimiento
$id = $_GET['id'] ?? 0;

try {
    $movimiento = $movimientoService->obtenerPorId($id);
} catch (Exception $e) {
    header('Location: ' . BASE_URL . '/movimientos?error=' . urlencode($e->getMessage()));
    exit;
}

$pageTitle = 'Detalle de Movimiento';
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/assets/css/app.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/assets/css/movimientos.css" rel="stylesheet">
    <style>
        .detail-card {
            border-radius: 12px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            transition: transform 0.2s ease;
        }
        
        .detail-card:hover {
            transform: translateY(-2px);
        }
        
        .detail-label {
            font-weight: 600;
            color: #495057;
            margin-bottom: 5px;
        }
        
        .detail-value {
            font-size: 1.1rem;
            color: #212529;
            margin-bottom: 15px;
        }
        
        .movement-type-badge {
            font-size: 1rem;
            padding: 8px 16px;
            border-radius: 20px;
        }
        
        .timeline-item {
            border-left: 3px solid #dee2e6;
            padding-left: 20px;
            margin-bottom: 20px;
            position: relative;
        }
        
        .timeline-item::before {
            content: '';
            position: absolute;
            left: -6px;
            top: 0;
            width: 9px;
            height: 9px;
            background: #007bff;
            border-radius: 50%;
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <?php include '../views/layouts/navbar.php'; ?>

    <div class="container-fluid py-4">
        <div class="row">
            <!-- Sidebar -->
            <?php include '../views/layouts/sidebar.php'; ?>

            <!-- Contenido Principal -->
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <!-- Header -->
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">
                        <i class="fas fa-info-circle me-2"></i>
                        Detalle de Movimiento #<?php echo $movimiento->id; ?>
                    </h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <a href="<?php echo BASE_URL; ?>/movimientos" class="btn btn-outline-secondary">
                            <i class="fas fa-arrow-left me-1"></i>
                            Volver a Movimientos
                        </a>
                    </div>
                </div>

                <!-- Información del Movimiento -->
                <div class="row">
                    <div class="col-lg-8">
                        <div class="card detail-card mb-4">
                            <div class="card-header bg-primary text-white">
                                <h5 class="mb-0">
                                    <i class="fas fa-exchange-alt me-2"></i>
                                    Información del Movimiento
                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="detail-label">Tipo de Movimiento</div>
                                        <div class="detail-value">
                                            <span class="badge movement-type-badge <?php echo $movimiento->tipo_movimiento === 'entrada' ? 'bg-success' : 'bg-danger'; ?>">
                                                <i class="fas <?php echo $movimiento->tipo_movimiento === 'entrada' ? 'fa-plus' : 'fa-minus'; ?> me-1"></i>
                                                <?php echo ucfirst($movimiento->tipo_movimiento); ?>
                                            </span>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="detail-label">Fecha y Hora</div>
                                        <div class="detail-value">
                                            <i class="fas fa-calendar me-2 text-muted"></i>
                                            <?php echo $movimiento->getFechaFormateada(); ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="detail-label">Utensilio</div>
                                        <div class="detail-value">
                                            <i class="fas fa-utensils me-2 text-muted"></i>
                                            <?php echo htmlspecialchars($movimiento->nombre_utensilio ?? 'N/A'); ?>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="detail-label">Cantidad</div>
                                        <div class="detail-value">
                                            <i class="fas fa-hashtag me-2 text-muted"></i>
                                            <span class="fw-bold <?php echo $movimiento->tipo_movimiento === 'entrada' ? 'text-success' : 'text-danger'; ?>">
                                                <?php echo $movimiento->getImpacto(); ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-12">
                                        <div class="detail-label">Motivo</div>
                                        <div class="detail-value">
                                            <div class="p-3 bg-light rounded">
                                                <?php echo nl2br(htmlspecialchars($movimiento->motivo)); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <?php if ($movimiento->observaciones): ?>
                                <div class="row">
                                    <div class="col-12">
                                        <div class="detail-label">Observaciones</div>
                                        <div class="detail-value">
                                            <div class="p-3 bg-warning bg-opacity-10 rounded border-start border-warning border-3">
                                                <i class="fas fa-sticky-note me-2 text-warning"></i>
                                                <?php echo nl2br(htmlspecialchars($movimiento->observaciones)); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Información Adicional -->
                    <div class="col-lg-4">
                        <!-- Usuario -->
                        <div class="card detail-card mb-4">
                            <div class="card-header bg-info text-white">
                                <h6 class="mb-0">
                                    <i class="fas fa-user me-2"></i>
                                    Usuario Responsable
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="text-center">
                                    <i class="fas fa-user-circle fa-3x text-muted mb-3"></i>
                                    <div class="detail-value">
                                        <?php echo htmlspecialchars($movimiento->nombre_usuario ?? 'No especificado'); ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Línea de Tiempo -->
                        <div class="card detail-card">
                            <div class="card-header bg-secondary text-white">
                                <h6 class="mb-0">
                                    <i class="fas fa-clock me-2"></i>
                                    Línea de Tiempo
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="timeline-item">
                                    <div class="fw-bold">Movimiento Registrado</div>
                                    <div class="text-muted small">
                                        <?php echo $movimiento->getFechaFormateada(); ?>
                                    </div>
                                </div>
                                
                                <div class="timeline-item">
                                    <div class="fw-bold">Tipo: <?php echo ucfirst($movimiento->tipo_movimiento); ?></div>
                                    <div class="text-muted small">
                                        Cantidad: <?php echo $movimiento->getImpacto(); ?>
                                    </div>
                                </div>
                                
                                <div class="timeline-item">
                                    <div class="fw-bold">Estado: Procesado</div>
                                    <div class="text-muted small">
                                        Impacto en inventario aplicado
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Acciones Rápidas -->
                <div class="row mt-4">
                    <div class="col-12">
                        <div class="card detail-card">
                            <div class="card-header bg-light">
                                <h6 class="mb-0">
                                    <i class="fas fa-tools me-2"></i>
                                    Acciones Disponibles
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="btn-group" role="group">
                                    <button type="button" class="btn btn-outline-primary" onclick="window.print()">
                                        <i class="fas fa-print me-1"></i>
                                        Imprimir
                                    </button>
                                    
                                    <button type="button" class="btn btn-outline-info" onclick="exportarPDF()">
                                        <i class="fas fa-file-pdf me-1"></i>
                                        Exportar PDF
                                    </button>
                                    
                                    <?php if ($authService->esAdministrador()): ?>
                                    <button type="button" class="btn btn-outline-warning" onclick="corregirMovimiento(<?php echo $movimiento->id; ?>)">
                                        <i class="fas fa-edit me-1"></i>
                                        Corregir
                                    </button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function exportarPDF() {
            // Implementar exportación a PDF
            alert('Función de exportación en desarrollo');
        }

        function corregirMovimiento(id) {
            if (confirm('¿Está seguro de que desea corregir este movimiento?')) {
                // Implementar corrección de movimiento
                alert('Función de corrección en desarrollo');
            }
        }

        // Atajos de teclado
        document.addEventListener('keydown', function(e) {
            if (e.ctrlKey) {
                switch(e.key) {
                    case 'p':
                        e.preventDefault();
                        window.print();
                        break;
                    case 'b':
                        e.preventDefault();
                        window.location.href = '<?php echo BASE_URL; ?>/movimientos';
                        break;
                }
            }
        });
    </script>
</body>
</html>