<!-- Navbar principal del sistema -->
<nav class="navbar navbar-expand-lg navbar-dark bg-cayejero">
    <div class="container-fluid">
        <a class="navbar-brand d-flex align-items-center" href="/app-web-Enciso/public/dashboard">
            <img src="../../assets/images/logo_app.png" alt="Cayejero" class="navbar-logo me-2">
            <span class="navbar-title">Sistema de Inventario</span>
        </a>
        
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav me-auto">
                <li class="nav-item">
                    <a class="nav-link" href="/app-web-Enciso/public/dashboard">
                        <i class="fas fa-tachometer-alt me-1"></i> Dashboard
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="/app-web-Enciso/public/inventario">
                        <i class="fas fa-boxes me-1"></i> Inventario
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="/app-web-Enciso/public/reportes">
                        <i class="fas fa-chart-bar me-1"></i> Reportes
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo strpos($_SERVER['REQUEST_URI'], 'usuarios') !== false ? 'active' : ''; ?>" 
                       href="<?php echo BASE_URL; ?>/usuarios">
                        <i class="fas fa-users me-1"></i> Usuarios
                    </a>
                </li>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="adminDropdown" role="button" data-bs-toggle="dropdown">
                        <i class="fas fa-cog me-1"></i> Admin
                    </a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>/auditoria">
                            <i class="fas fa-history me-2"></i> Auditoría
                        </a></li>
                        <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>/configuracion">
                            <i class="fas fa-wrench me-2"></i> Configuración
                        </a></li>
                    </ul>
                </li>
            </ul>
            
            <!-- Notificaciones -->
            <ul class="navbar-nav me-3">
                <li class="nav-item dropdown">
                    <a class="nav-link position-relative" href="#" id="notificacionesDropdown" role="button" data-bs-toggle="dropdown">
                        <i class="fas fa-bell"></i>
                        <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger" id="contadorNotificaciones" style="display: none;">
                            0
                        </span>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end" style="min-width: 300px;">
                        <li class="dropdown-header">
                            <i class="fas fa-bell me-2"></i>
                            Notificaciones
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <div id="listaNotificaciones">
                            <li class="dropdown-item-text text-muted text-center py-3">
                                No hay notificaciones nuevas
                            </li>
                        </div>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item text-center" href="<?php echo BASE_URL; ?>/notificaciones">
                            Ver todas las notificaciones
                        </a></li>
                    </ul>
                </li>
            </ul>
            
            <!-- Usuario -->
            <ul class="navbar-nav">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown">
                        <i class="fas fa-user me-1"></i>
                        <?php echo htmlspecialchars($_SESSION['usuario_nombre'] ?? 'Usuario'); ?>
                        <span class="badge bg-secondary ms-1"><?php echo ucfirst($_SESSION['usuario_rol'] ?? 'usuario'); ?></span>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li class="dropdown-header">
                            <i class="fas fa-user me-2"></i>
                            <?php echo htmlspecialchars($_SESSION['usuario_nombre'] ?? 'Usuario'); ?>
                            <br><small class="text-muted"><?php echo htmlspecialchars($_SESSION['usuario_email'] ?? 'usuario@empresa.com'); ?></small>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>/perfil">
                            <i class="fas fa-user-cog me-2"></i> Mi Perfil
                        </a></li>
                        <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>/cambiar-password">
                            <i class="fas fa-lock me-2"></i> Cambiar Contraseña
                        </a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>/logout">
                            <i class="fas fa-sign-out-alt me-2"></i> Cerrar Sesión
                        </a></li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
</nav>
