<?php
/**
 * PÁGINA DE REPORTES - ENFOQUE EN PÉRDIDAS
 */

// Verificar autenticación
if (!isset($_SESSION['usuario_id'])) {
    header('Location: /app-web-Enciso/public/login');
    exit;
}

// Obtener conexión a base de datos
try {
    $pdo = new PDO("mysql:host=localhost;dbname=server_inventario_utensilios;charset=utf8mb4", 'server_admin', 'Admin2025!');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Obtener parámetros de filtro
    $periodo = $_GET['periodo'] ?? 'mes';
    $fecha_inicio = $_GET['fecha_inicio'] ?? '';
    $fecha_fin = $_GET['fecha_fin'] ?? '';
    
    // Calcular fechas según período
    if (empty($fecha_inicio) || empty($fecha_fin)) {
        $hoy = new DateTime();
        switch ($periodo) {
            case 'semana':
                $fecha_inicio = $hoy->modify('-7 days')->format('Y-m-d');
                $fecha_fin = (new DateTime())->format('Y-m-d');
                break;
            case 'mes':
                $fecha_inicio = $hoy->modify('-30 days')->format('Y-m-d');
                $fecha_fin = (new DateTime())->format('Y-m-d');
                break;
            case 'trimestre':
                $fecha_inicio = $hoy->modify('-90 days')->format('Y-m-d');
                $fecha_fin = (new DateTime())->format('Y-m-d');
                break;
            default:
                $fecha_inicio = $hoy->modify('-30 days')->format('Y-m-d');
                $fecha_fin = (new DateTime())->format('Y-m-d');
        }
    }
    
    // Reporte de salidas (pérdidas)
    $stmt = $pdo->prepare("
        SELECT 
            m.*, 
            u.nombre as utensilio_nombre,
            u.categoria,
            usr.nombre as usuario_nombre
        FROM movimientos_inventario m
        LEFT JOIN utensilios u ON m.utensilio_id = u.id
        LEFT JOIN usuarios usr ON m.usuario_id = usr.id
        WHERE m.tipo_movimiento = 'salida' 
        AND DATE(m.fecha_movimiento) BETWEEN ? AND ?
        ORDER BY m.fecha_movimiento DESC
    ");
    $stmt->execute([$fecha_inicio, $fecha_fin]);
    $perdidas = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Estadísticas de pérdidas
    $stmt = $pdo->prepare("
        SELECT 
            COUNT(*) as total_movimientos,
            SUM(cantidad) as total_unidades,
            COUNT(DISTINCT utensilio_id) as items_afectados,
            u.categoria,
            COUNT(*) as movimientos_categoria
        FROM movimientos_inventario m
        LEFT JOIN utensilios u ON m.utensilio_id = u.id
        WHERE m.tipo_movimiento = 'salida' 
        AND DATE(m.fecha_movimiento) BETWEEN ? AND ?
        GROUP BY u.categoria
        ORDER BY total_unidades DESC
    ");
    $stmt->execute([$fecha_inicio, $fecha_fin]);
    $estadisticas_categoria = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Resumen general
    $stmt = $pdo->prepare("
        SELECT 
            COUNT(*) as total_movimientos,
            SUM(cantidad) as total_unidades,
            COUNT(DISTINCT utensilio_id) as items_afectados
        FROM movimientos_inventario m
        WHERE m.tipo_movimiento = 'salida' 
        AND DATE(m.fecha_movimiento) BETWEEN ? AND ?
    ");
    $stmt->execute([$fecha_inicio, $fecha_fin]);
    $resumen = $stmt->fetch(PDO::FETCH_ASSOC);
    
} catch (Exception $e) {
    $error = $e->getMessage();
    $perdidas = [];
    $estadisticas_categoria = [];
    $resumen = ['total_movimientos' => 0, 'total_unidades' => 0, 'items_afectados' => 0];
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reportes de Pérdidas - Sistema CAYEJERO</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="../../assets/css/dashboard.css?v=20251210005" rel="stylesheet">
    <link href="../../assets/css/utensilios.css?v=20251210005" rel="stylesheet">
    <style>
        /* CAYEJERO - Tema oscuro para reportes */
        body, html { background: #0a0a0a !important; }
        .container-fluid { background: #0a0a0a !important; }
        
        /* Navbar */
        .navbar { background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%) !important; border-bottom: 3px solid #FF8C00 !important; min-height: 80px !important; }
        .navbar-logo { height: 70px !important; filter: drop-shadow(0 0 10px rgba(255, 140, 0, 0.5)); }
        .navbar .nav-link { color: #FFD700 !important; font-weight: 600 !important; }
        .navbar .nav-link:hover { color: #FF8C00 !important; }
        .navbar .nav-link i { color: #FF8C00 !important; }
        
        /* Cards */
        .card { background: #1a1a1a !important; border: 2px solid rgba(255, 140, 0, 0.3) !important; }
        .card-body { background: #1a1a1a !important; }
        .card-header { background: linear-gradient(135deg, rgba(255, 140, 0, 0.3), rgba(255, 215, 0, 0.3)) !important; color: #FFD700 !important; border-bottom: 2px solid #FF8C00 !important; }
        
        /* Textos */
        h1, h2, h3, h4, h5, h6 { color: #FFD700 !important; font-weight: 800 !important; text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.8); }
        label, .form-label { color: #FFD700 !important; font-weight: 600 !important; }
        p, span, small, .text-muted { color: #e0e0e0 !important; }
        
        /* Formularios */
        .form-control, .form-select { background: rgba(45, 45, 45, 0.8) !important; border: 2px solid rgba(255, 140, 0, 0.4) !important; color: #fff !important; }
        .form-control:focus, .form-select:focus { background: rgba(255, 140, 0, 0.15) !important; border-color: #FF8C00 !important; }
        select option { background: #1a1a1a !important; color: #FFD700 !important; font-weight: 600; }
        
        /* Tablas */
        .table { background: #1a1a1a !important; }
        .table thead th { background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%) !important; color: #FFD700 !important; border-bottom: 2px solid #FF8C00 !important; }
        .table tbody tr { background-color: #1a1a1a !important; }
        .table tbody tr:nth-child(even) { background-color: #2d2d2d !important; }
        .table tbody tr:hover { background-color: rgba(255, 140, 0, 0.3) !important; }
        .table tbody td { color: #ffffff !important; font-weight: 600; }
        
        /* Botones */
        .btn-primary { background: linear-gradient(135deg, #FF8C00, #FFD700) !important; border: none !important; color: #000 !important; font-weight: 700 !important; }
        .btn-secondary { background: #5a6268 !important; color: #fff !important; }
        .btn-danger { background: linear-gradient(135deg, #dc3545, #c82333) !important; border: none !important; }
        .badge { font-weight: 700 !important; }
    </style>
</head>
<body>
    <!-- Navbar -->
    <?php include __DIR__ . '/../partials/navbar-simple.php'; ?>
    
    <div class="container-fluid py-4">
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h2><i class="fas fa-chart-line text-danger"></i> Reportes de Pérdidas</h2>
                <p class="text-muted">Control de salidas y mermas del inventario</p>
            </div>
            <a href="/app-web-Enciso/public/dashboard" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Volver al Dashboard
            </a>
        </div>

        <!-- Filtros -->
        <div class="card mb-4">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-filter"></i> Filtros de Período</h6>
            </div>
            <div class="card-body">
                <form method="GET" class="row g-3">
                    <div class="col-md-3">
                        <label for="periodo" class="form-label">Período Predefinido</label>
                        <select class="form-control" id="periodo" name="periodo">
                            <option value="semana" <?php echo $periodo === 'semana' ? 'selected' : ''; ?>>Última Semana</option>
                            <option value="mes" <?php echo $periodo === 'mes' ? 'selected' : ''; ?>>Último Mes</option>
                            <option value="trimestre" <?php echo $periodo === 'trimestre' ? 'selected' : ''; ?>>Último Trimestre</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="fecha_inicio" class="form-label">Fecha Inicio</label>
                        <input type="date" class="form-control" id="fecha_inicio" name="fecha_inicio" value="<?php echo $fecha_inicio; ?>">
                    </div>
                    <div class="col-md-3">
                        <label for="fecha_fin" class="form-label">Fecha Fin</label>
                        <input type="date" class="form-control" id="fecha_fin" name="fecha_fin" value="<?php echo $fecha_fin; ?>">
                    </div>
                    <div class="col-md-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary me-2">
                            <i class="fas fa-search"></i> Filtrar
                        </button>
                        <a href="/app-web-Enciso/public/reportes" class="btn btn-outline-secondary">
                            <i class="fas fa-refresh"></i> Limpiar
                        </a>
                    </div>
                </form>
            </div>
        </div>

        <!-- Resumen de pérdidas -->
        <div class="row mb-4">
            <div class="col-md-4">
                <div class="card text-center border-danger">
                    <div class="card-body">
                        <i class="fas fa-exclamation-triangle fa-3x text-danger mb-3"></i>
                        <h3 class="text-danger"><?php echo $resumen['total_unidades'] ?? 0; ?></h3>
                        <p class="text-muted">Unidades Perdidas</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card text-center border-warning">
                    <div class="card-body">
                        <i class="fas fa-list fa-3x text-warning mb-3"></i>
                        <h3 class="text-warning"><?php echo $resumen['total_movimientos'] ?? 0; ?></h3>
                        <p class="text-muted">Movimientos de Salida</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card text-center border-info">
                    <div class="card-body">
                        <i class="fas fa-utensils fa-3x text-info mb-3"></i>
                        <h3 class="text-info"><?php echo $resumen['items_afectados'] ?? 0; ?></h3>
                        <p class="text-muted">Items Diferentes</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Lista detallada de pérdidas -->
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="fas fa-list"></i> Detalle de Pérdidas</h6>
                    </div>
                    <div class="card-body">
                        <?php if (empty($perdidas)): ?>
                            <div class="text-center py-5">
                                <i class="fas fa-smile fa-3x text-success mb-3"></i>
                                <h5 class="text-success">¡Sin pérdidas registradas!</h5>
                                <p class="text-muted">No se encontraron movimientos de salida en el período seleccionado</p>
                            </div>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Fecha</th>
                                            <th>Utensilio</th>
                                            <th>Categoría</th>
                                            <th>Cantidad</th>
                                            <th>Motivo</th>
                                            <th>Usuario</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($perdidas as $perdida): ?>
                                            <tr>
                                                <td>
                                                    <small><?php echo date('d/m/Y H:i', strtotime($perdida['fecha_movimiento'])); ?></small>
                                                </td>
                                                <td>
                                                    <strong><?php echo htmlspecialchars($perdida['utensilio_nombre']); ?></strong>
                                                </td>
                                                <td>
                                                    <span class="badge bg-secondary"><?php echo htmlspecialchars($perdida['categoria']); ?></span>
                                                </td>
                                                <td>
                                                    <span class="badge bg-danger"><?php echo $perdida['cantidad']; ?></span>
                                                </td>
                                                <td>
                                                    <small class="text-muted"><?php echo htmlspecialchars($perdida['motivo']); ?></small>
                                                </td>
                                                <td>
                                                    <small><?php echo htmlspecialchars($perdida['usuario_nombre'] ?? 'N/A'); ?></small>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Estadísticas por categoría -->
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="fas fa-chart-pie"></i> Pérdidas por Categoría</h6>
                    </div>
                    <div class="card-body">
                        <?php if (empty($estadisticas_categoria)): ?>
                            <div class="text-center py-4">
                                <i class="fas fa-chart-pie fa-2x text-muted mb-3"></i>
                                <p class="text-muted">Sin datos para mostrar</p>
                            </div>
                        <?php else: ?>
                            <?php foreach ($estadisticas_categoria as $categoria): ?>
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div>
                                        <h6 class="mb-0"><?php echo htmlspecialchars($categoria['categoria']); ?></h6>
                                        <small class="text-muted"><?php echo $categoria['movimientos_categoria']; ?> movimientos</small>
                                    </div>
                                    <span class="badge bg-danger fs-6"><?php echo $categoria['total_unidades'] ?? 0; ?></span>
                                </div>
                                <hr class="my-2">
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Información del sistema -->
                <div class="card mt-4">
                    <div class="card-header bg-info text-white">
                        <h6 class="mb-0"><i class="fas fa-info-circle me-2"></i>Información</h6>
                    </div>
                    <div class="card-body">
                        <p><strong>Sistema de Gestión:</strong></p>
                        <ul class="list-unstyled">
                            <li><i class="fas fa-check text-success me-2"></i>Movimientos de Entrada y Salida</li>
                            <li><i class="fas fa-check text-success me-2"></i>Control de pérdidas y mermas</li>
                            <li><i class="fas fa-check text-success me-2"></i>Trazabilidad completa con motivos</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>


