<?php
/**
 * Vista principal de reportes
 */

require_once '../config/config.php';
require_once '../src/BLL/ReporteService.php';
require_once '../src/BLL/AuthService.php';

$authService = new AuthService();
$reporteService = new ReporteService();

// Verificar autenticación y permisos
$authService->verificarSesion();
$authService->verificarPermiso('reportes_ver');

$usuario = $authService->getUsuarioActual();
$pageTitle = 'Reportes del Sistema';

// Obtener datos para el dashboard de reportes
$reporteEjecutivo = $reporteService->generarReporteEjecutivo('mes');
$alertas = $reporteService->generarReporteAlertas();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/assets/css/app.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/assets/css/reportes.css" rel="stylesheet">
</head>
<body>
    <!-- Navbar -->
    <?php include '../views/layouts/navbar.php'; ?>

    <div class="container-fluid py-4">
        <div class="row">
            <!-- Sidebar -->
            <?php include '../views/layouts/sidebar.php'; ?>

            <!-- Contenido Principal -->
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <!-- Header -->
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">
                        <i class="fas fa-chart-bar me-2"></i>
                        Sistema de Reportes
                    </h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <div class="btn-group me-2">
                            <button type="button" class="btn btn-primary" onclick="generarReporteRapido()">
                                <i class="fas fa-plus me-1"></i>
                                Generar Reporte
                            </button>
                            <button type="button" class="btn btn-outline-secondary" onclick="programarReporte()">
                                <i class="fas fa-clock me-1"></i>
                                Programar
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Resumen Ejecutivo -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="card report-card">
                            <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                                <h5 class="mb-0">
                                    <i class="fas fa-tachometer-alt me-2"></i>
                                    Resumen Ejecutivo - <?php echo $reporteEjecutivo['periodo']; ?>
                                </h5>
                                <small><?php echo date('d/m/Y', strtotime($reporteEjecutivo['fechas']['inicio'])); ?> - <?php echo date('d/m/Y', strtotime($reporteEjecutivo['fechas']['fin'])); ?></small>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-lg-3 col-md-6 mb-3">
                                        <div class="stats-card bg-success bg-opacity-10 border-success">
                                            <div class="stats-icon text-success">
                                                <i class="fas fa-cubes"></i>
                                            </div>
                                            <div class="stats-content">
                                                <h3><?php echo number_format($reporteEjecutivo['inventario']['total_items']); ?></h3>
                                                <p class="mb-0">Items en Inventario</p>
                                                <small class="text-muted"><?php echo $reporteEjecutivo['inventario']['total_utensilios']; ?> tipos de utensilios</small>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-lg-3 col-md-6 mb-3">
                                        <div class="stats-card bg-info bg-opacity-10 border-info">
                                            <div class="stats-icon text-info">
                                                <i class="fas fa-exchange-alt"></i>
                                            </div>
                                            <div class="stats-content">
                                                <h3><?php echo number_format($reporteEjecutivo['movimientos']['totales']['movimientos']); ?></h3>
                                                <p class="mb-0">Movimientos del Período</p>
                                                <small class="text-muted">Balance: <?php echo $reporteEjecutivo['movimientos']['totales']['balance_neto'] > 0 ? '+' : ''; ?><?php echo $reporteEjecutivo['movimientos']['totales']['balance_neto']; ?></small>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-lg-3 col-md-6 mb-3">
                                        <div class="stats-card bg-warning bg-opacity-10 border-warning">
                                            <div class="stats-icon text-warning">
                                                <i class="fas fa-exclamation-triangle"></i>
                                            </div>
                                            <div class="stats-content">
                                                <h3><?php echo $alertas['resumen']['por_tipo']['criticas'] + $alertas['resumen']['por_tipo']['advertencias']; ?></h3>
                                                <p class="mb-0">Alertas Activas</p>
                                                <small class="text-muted"><?php echo $alertas['resumen']['por_tipo']['criticas']; ?> críticas, <?php echo $alertas['resumen']['por_tipo']['advertencias']; ?> advertencias</small>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-lg-3 col-md-6 mb-3">
                                        <div class="stats-card bg-secondary bg-opacity-10 border-secondary">
                                            <div class="stats-icon text-secondary">
                                                <i class="fas fa-users"></i>
                                            </div>
                                            <div class="stats-content">
                                                <h3><?php echo $reporteEjecutivo['usuarios']['usuarios_activos']; ?></h3>
                                                <p class="mb-0">Usuarios Activos</p>
                                                <small class="text-muted"><?php echo $reporteEjecutivo['usuarios']['total_movimientos']; ?> operaciones realizadas</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Tipos de Reportes -->
                <div class="row mb-4">
                    <div class="col-12">
                        <h4 class="mb-3">Tipos de Reportes Disponibles</h4>
                    </div>
                    
                    <div class="col-lg-4 col-md-6 mb-3">
                        <div class="card report-type-card h-100" onclick="generarReporte('inventario')">
                            <div class="card-body text-center">
                                <div class="report-icon text-success mb-3">
                                    <i class="fas fa-warehouse fa-3x"></i>
                                </div>
                                <h5>Reporte de Inventario</h5>
                                <p class="text-muted">Estado actual del inventario, stock disponible, valorización y alertas de reposición.</p>
                                <div class="report-stats">
                                    <small class="badge bg-success"><?php echo $reporteEjecutivo['inventario']['total_utensilios']; ?> utensilios</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6 mb-3">
                        <div class="card report-type-card h-100" onclick="generarReporte('movimientos')">
                            <div class="card-body text-center">
                                <div class="report-icon text-info mb-3">
                                    <i class="fas fa-chart-line fa-3x"></i>
                                </div>
                                <h5>Reporte de Movimientos</h5>
                                <p class="text-muted">Análisis de entradas y salidas, tendencias de uso y estadísticas por período.</p>
                                <div class="report-stats">
                                    <small class="badge bg-info"><?php echo $reporteEjecutivo['movimientos']['totales']['movimientos']; ?> movimientos</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6 mb-3">
                        <div class="card report-type-card h-100" onclick="generarReporte('usuarios')">
                            <div class="card-body text-center">
                                <div class="report-icon text-primary mb-3">
                                    <i class="fas fa-user-chart fa-3x"></i>
                                </div>
                                <h5>Reporte de Usuarios</h5>
                                <p class="text-muted">Actividad por usuario, frecuencia de uso y estadísticas de rendimiento.</p>
                                <div class="report-stats">
                                    <small class="badge bg-primary"><?php echo $reporteEjecutivo['usuarios']['usuarios_activos']; ?> usuarios activos</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6 mb-3">
                        <div class="card report-type-card h-100" onclick="generarReporte('alertas')">
                            <div class="card-body text-center">
                                <div class="report-icon text-warning mb-3">
                                    <i class="fas fa-bell fa-3x"></i>
                                </div>
                                <h5>Reporte de Alertas</h5>
                                <p class="text-muted">Stock bajo, items agotados y recomendaciones para optimizar el inventario.</p>
                                <div class="report-stats">
                                    <small class="badge bg-warning"><?php echo $alertas['resumen']['total_alertas']; ?> alertas</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6 mb-3">
                        <div class="card report-type-card h-100" onclick="generarReporte('ejecutivo')">
                            <div class="card-body text-center">
                                <div class="report-icon text-dark mb-3">
                                    <i class="fas fa-chart-pie fa-3x"></i>
                                </div>
                                <h5>Reporte Ejecutivo</h5>
                                <p class="text-muted">Resumen completo con KPIs, métricas principales y análisis de tendencias.</p>
                                <div class="report-stats">
                                    <small class="badge bg-dark">Completo</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6 mb-3">
                        <div class="card report-type-card h-100" onclick="generarReporte('personalizado')">
                            <div class="card-body text-center">
                                <div class="report-icon text-secondary mb-3">
                                    <i class="fas fa-cogs fa-3x"></i>
                                </div>
                                <h5>Reporte Personalizado</h5>
                                <p class="text-muted">Configure filtros personalizados, períodos específicos y métricas a medida.</p>
                                <div class="report-stats">
                                    <small class="badge bg-secondary">Configurable</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Alertas Críticas -->
                <?php if ($alertas['resumen']['por_tipo']['criticas'] > 0): ?>
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="alert alert-danger border-0 shadow-sm">
                            <div class="d-flex align-items-center mb-2">
                                <i class="fas fa-exclamation-triangle fa-lg me-2"></i>
                                <h5 class="alert-heading mb-0">Alertas Críticas Detectadas</h5>
                            </div>
                            <p class="mb-2">Se han detectado <strong><?php echo $alertas['resumen']['por_tipo']['criticas']; ?> alertas críticas</strong> que requieren atención inmediata.</p>
                            <div class="d-flex gap-2">
                                <a href="<?php echo BASE_URL; ?>/reportes/alertas" class="btn btn-danger btn-sm">
                                    <i class="fas fa-eye me-1"></i>
                                    Ver Alertas
                                </a>
                                <button type="button" class="btn btn-outline-danger btn-sm" onclick="exportarAlertas()">
                                    <i class="fas fa-download me-1"></i>
                                    Exportar
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Historial de Reportes Recientes -->
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0">
                                    <i class="fas fa-history me-2"></i>
                                    Reportes Recientes
                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>Tipo de Reporte</th>
                                                <th>Período</th>
                                                <th>Generado por</th>
                                                <th>Fecha</th>
                                                <th>Acciones</th>
                                            </tr>
                                        </thead>
                                        <tbody id="reportesRecientes">
                                            <tr>
                                                <td colspan="5" class="text-center text-muted py-4">
                                                    <i class="fas fa-info-circle me-2"></i>
                                                    No hay reportes recientes disponibles
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <!-- Modal Generador de Reportes -->
    <div class="modal fade" id="reporteModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="fas fa-chart-bar me-2"></i>
                        Generar Reporte
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="reporteForm">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Tipo de Reporte</label>
                                <select class="form-select" name="tipo_reporte" required>
                                    <option value="">Seleccionar...</option>
                                    <option value="inventario">Inventario Completo</option>
                                    <option value="movimientos">Movimientos por Período</option>
                                    <option value="usuarios">Actividad de Usuarios</option>
                                    <option value="alertas">Alertas y Notificaciones</option>
                                    <option value="ejecutivo">Reporte Ejecutivo</option>
                                </select>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Formato</label>
                                <select class="form-select" name="formato" required>
                                    <option value="html">Vista HTML</option>
                                    <option value="pdf">PDF</option>
                                    <option value="excel">Excel</option>
                                    <option value="csv">CSV</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="row periodo-fields" style="display: none;">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Fecha Inicio</label>
                                <input type="date" class="form-control" name="fecha_inicio">
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Fecha Fin</label>
                                <input type="date" class="form-control" name="fecha_fin" value="<?php echo date('Y-m-d'); ?>">
                            </div>
                        </div>
                        
                        <div class="mb-3 filtros-adicionales" style="display: none;">
                            <label class="form-label">Filtros Adicionales</label>
                            <div class="border rounded p-3 bg-light">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="incluir_inactivos" id="incluirInactivos">
                                    <label class="form-check-label" for="incluirInactivos">
                                        Incluir elementos inactivos
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="solo_alertas" id="soloAlertas">
                                    <label class="form-check-label" for="soloAlertas">
                                        Solo items con alertas
                                    </label>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-primary" onclick="procesarReporte()">
                        <i class="fas fa-play me-1"></i>
                        Generar Reporte
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/assets/js/reportes.js"></script>
</body>
</html>