<?php
/**
 * REPORTES DE PÉRDIDAS - Sistema de Inventario
 */

// Verificar autenticación
if (!isset($_SESSION['usuario_id'])) {
    header('Location: /app-web-Enciso/public/login');
    exit;
}

// Configurar zona horaria
date_default_timezone_set('America/Mexico_City');

try {
    $pdo = new PDO("mysql:host=localhost;dbname=server_inventario_utensilios;charset=utf8mb4", 'server_admin', 'Admin2025!');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Parámetros de filtro
    $periodo = $_GET['periodo'] ?? 'mes';
    $fecha_inicio = $_GET['fecha_inicio'] ?? '';
    $fecha_fin = $_GET['fecha_fin'] ?? '';
    
    // Calcular fechas según período
    if (empty($fecha_inicio) || empty($fecha_fin)) {
        switch ($periodo) {
            case 'semana':
                $fecha_inicio = date('Y-m-d', strtotime('-7 days'));
                $fecha_fin = date('Y-m-d');
                break;
            case 'mes':
                $fecha_inicio = date('Y-m-d', strtotime('-30 days'));
                $fecha_fin = date('Y-m-d');
                break;
            case 'trimestre':
                $fecha_inicio = date('Y-m-d', strtotime('-90 days'));
                $fecha_fin = date('Y-m-d');
                break;
            default:
                $fecha_inicio = date('Y-m-d', strtotime('-30 days'));
                $fecha_fin = date('Y-m-d');
        }
    }
    
    // Consulta de pérdidas (salidas)
    $stmt = $pdo->prepare("
        SELECT 
            m.*, 
            u.nombre as utensilio_nombre,
            u.categoria
        FROM movimientos_inventario m
        LEFT JOIN utensilios u ON m.utensilio_id = u.id
        WHERE m.tipo_movimiento = 'salida' 
        AND DATE(m.fecha_movimiento) BETWEEN ? AND ?
        ORDER BY m.fecha_movimiento DESC
    ");
    $stmt->execute([$fecha_inicio, $fecha_fin]);
    $perdidas = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Estadísticas por categoría
    $stmt = $pdo->prepare("
        SELECT 
            u.categoria,
            COUNT(m.id) as total_movimientos,
            SUM(m.cantidad) as total_perdido
        FROM movimientos_inventario m
        LEFT JOIN utensilios u ON m.utensilio_id = u.id
        WHERE m.tipo_movimiento = 'salida' 
        AND DATE(m.fecha_movimiento) BETWEEN ? AND ?
        GROUP BY u.categoria
        ORDER BY total_perdido DESC
    ");
    $stmt->execute([$fecha_inicio, $fecha_fin]);
    $perdidas_por_categoria = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Totales
    $total_perdidas = array_sum(array_column($perdidas_por_categoria, 'total_perdido'));
    $total_movimientos = count($perdidas);

} catch (Exception $e) {
    $error = "Error: " . $e->getMessage();
    $perdidas = [];
    $perdidas_por_categoria = [];
    $total_perdidas = 0;
    $total_movimientos = 0;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reportes de Pérdidas - Sistema de Inventario</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .loss-row { background-color: #fff3cd; }
    </style>
</head>
<body>
    <!-- Navbar -->
    <?php include __DIR__ . '/../partials/navbar-simple.php'; ?>
    
    <div class="container-fluid py-4">
        <!-- Header -->
        <div class="row">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h2">
                        <i class="fas fa-chart-line text-danger"></i> 
                        Reporte de Pérdidas de Inventario
                    </h1>
                    <a href="/app-web-Enciso/public/inventario" class="btn btn-outline-primary">
                        <i class="fas fa-arrow-left"></i> Volver al Inventario
                    </a>
                </div>
            </div>
        </div>

        <!-- Filtros -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h6><i class="fas fa-filter me-2"></i>Seleccionar Período</h6>
                        <form method="GET">
                            <div class="row">
                                <div class="col-md-3">
                                    <select name="periodo" class="form-control">
                                        <option value="semana" <?php echo $periodo === 'semana' ? 'selected' : ''; ?>>Última Semana</option>
                                        <option value="mes" <?php echo $periodo === 'mes' ? 'selected' : ''; ?>>Último Mes</option>
                                        <option value="trimestre" <?php echo $periodo === 'trimestre' ? 'selected' : ''; ?>>Último Trimestre</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-search"></i> Generar
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <?php if (isset($error)): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <!-- Resumen -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card border-danger">
                    <div class="card-body text-center">
                        <i class="fas fa-exclamation-triangle fa-2x text-danger mb-2"></i>
                        <h4 class="text-danger"><?php echo $total_perdidas; ?></h4>
                        <small>Unidades Perdidas</small>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-warning">
                    <div class="card-body text-center">
                        <i class="fas fa-list fa-2x text-warning mb-2"></i>
                        <h4><?php echo $total_movimientos; ?></h4>
                        <small>Movimientos de Salida</small>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-info">
                    <div class="card-body text-center">
                        <i class="fas fa-calendar fa-2x text-info mb-2"></i>
                        <h6><?php echo date('d/m/Y', strtotime($fecha_inicio)); ?></h6>
                        <small>a <?php echo date('d/m/Y', strtotime($fecha_fin)); ?></small>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-success">
                    <div class="card-body text-center">
                        <i class="fas fa-layer-group fa-2x text-success mb-2"></i>
                        <h4><?php echo count($perdidas_por_categoria); ?></h4>
                        <small>Categorías Afectadas</small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Pérdidas por Categoría -->
        <div class="row mb-4">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header bg-warning text-dark">
                        <h6 class="mb-0"><i class="fas fa-chart-pie me-2"></i>Por Categoría</h6>
                    </div>
                    <div class="card-body">
                        <?php if (empty($perdidas_por_categoria)): ?>
                            <div class="text-center py-4">
                                <i class="fas fa-smile fa-3x text-success mb-3"></i>
                                <h6>¡Sin pérdidas!</h6>
                                <p>No hay salidas registradas en este período.</p>
                            </div>
                        <?php else: ?>
                            <?php foreach ($perdidas_por_categoria as $cat): ?>
                                <div class="d-flex justify-content-between mb-2">
                                    <span class="badge bg-secondary"><?php echo htmlspecialchars($cat['categoria']); ?></span>
                                    <span class="text-danger fw-bold"><?php echo $cat['total_perdido']; ?> unidades</span>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header bg-info text-white">
                        <h6 class="mb-0"><i class="fas fa-info-circle me-2"></i>Información</h6>
                    </div>
                    <div class="card-body">
                        <p><strong>Sistema de Gestión:</strong></p>
                        <ul class="list-unstyled">
                            <li><i class="fas fa-check text-success me-2"></i>Movimientos de Entrada y Salida</li>
                            <li><i class="fas fa-check text-success me-2"></i>Control de pérdidas y mermas</li>
                            <li><i class="fas fa-check text-success me-2"></i>Trazabilidad completa con motivos</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Detalle de Pérdidas -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header bg-dark text-white">
                        <h6 class="mb-0"><i class="fas fa-table me-2"></i>Detalle de Pérdidas</h6>
                    </div>
                    <div class="card-body">
                        <?php if (empty($perdidas)): ?>
                            <div class="text-center py-5">
                                <i class="fas fa-clipboard-check fa-3x text-success mb-3"></i>
                                <h5>¡Excelente Control!</h5>
                                <p>No se registraron pérdidas en el período seleccionado.</p>
                            </div>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Fecha</th>
                                            <th>Utensilio</th>
                                            <th>Categoría</th>
                                            <th>Cantidad</th>
                                            <th>Motivo</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($perdidas as $p): ?>
                                            <tr class="loss-row">
                                                <td><?php echo date('d/m/Y H:i', strtotime($p['fecha_movimiento'])); ?></td>
                                                <td><strong><?php echo htmlspecialchars($p['utensilio_nombre']); ?></strong></td>
                                                <td><span class="badge bg-secondary"><?php echo htmlspecialchars($p['categoria']); ?></span></td>
                                                <td><span class="text-danger fw-bold">-<?php echo $p['cantidad']; ?></span></td>
                                                <td><small><?php echo htmlspecialchars($p['motivo']); ?></small></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>


