<?php
/**
 * PÁGINA DE EDICIÓN DE USUARIO
 */

// Verificar autenticación
if (!isset($_SESSION['usuario_id'])) {
    header('Location: /app-web-Enciso/public/login');
    exit;
}

// Obtener configuración de base de datos
require_once __DIR__ . '/../../config/config.php';

// Verificar si se recibió un ID válido
$usuario_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($usuario_id <= 0) {
    header('Location: /app-web-Enciso/public/usuarios');
    exit;
}

try {
    $pdo = new PDO($dsn, $username, $password, $options);
    
    // Si es POST, procesar actualización
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $nombre = trim($_POST['nombre'] ?? '');
        $email = trim($_POST['email'] ?? '');
        $rol = trim($_POST['rol'] ?? '');
        $estado = trim($_POST['estado'] ?? '');
        
        // Validaciones básicas
        if (empty($nombre) || empty($email) || empty($rol) || empty($estado)) {
            $error = "Todos los campos son obligatorios";
        } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $error = "El email no es válido";
        } else {
            // Verificar que el email no esté en uso por otro usuario
            $stmt = $pdo->prepare("SELECT id FROM usuarios WHERE email = ? AND id != ?");
            $stmt->execute([$email, $usuario_id]);
            
            if ($stmt->rowCount() > 0) {
                $error = "El email ya está siendo usado por otro usuario";
            } else {
                // Actualizar usuario
                $activo_value = ($estado === 'activo') ? 1 : 0;
                $stmt = $pdo->prepare("
                    UPDATE usuarios 
                    SET nombre = ?, email = ?, rol = ?, activo = ?, fecha_actualizacion = NOW() 
                    WHERE id = ?
                ");
                
                if ($stmt->execute([$nombre, $email, $rol, $activo_value, $usuario_id])) {
                    $_SESSION['success_message'] = "Usuario actualizado exitosamente";
                    header('Location: /app-web-Enciso/public/usuarios');
                    exit;
                } else {
                    $error = "Error al actualizar el usuario";
                }
            }
        }
    }
    
    // Obtener datos del usuario
    $stmt = $pdo->prepare("SELECT *, CASE WHEN activo = 1 THEN 'activo' ELSE 'inactivo' END as estado FROM usuarios WHERE id = ?");
    $stmt->execute([$usuario_id]);
    $usuario = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$usuario) {
        header('Location: /app-web-Enciso/public/usuarios');
        exit;
    }
    
} catch (Exception $e) {
    $error = "Error de base de datos: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Usuario - Sistema de Gestión</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        /* === TEMA CAYEJERO GAMING === */
        * {
            background-color: transparent !important;
        }
        
        body, html {
            background: #0a0a0a !important;
            min-height: 100vh;
            color: #ffffff !important;
        }
        
        .card {
            background: #1a1a1a !important;
            border: 2px solid rgba(255, 140, 0, 0.3) !important;
            border-radius: 15px !important;
            box-shadow: 0 8px 32px rgba(255, 140, 0, 0.1) !important;
        }
        
        .card-header {
            background: linear-gradient(135deg, #FF8C00, #FFD700) !important;
            color: #000000 !important;
            font-weight: 800 !important;
            border-radius: 13px 13px 0 0 !important;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.3);
        }
        
        h1, h2, h3, h4, h5, h6 {
            color: #FFD700 !important;
            font-weight: 800 !important;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.8);
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #FF8C00, #FFD700) !important;
            border: none !important;
            color: #000000 !important;
            font-weight: 700 !important;
            padding: 12px 30px !important;
            transition: all 0.3s ease !important;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px) !important;
            box-shadow: 0 6px 20px rgba(255, 140, 0, 0.4) !important;
            background: linear-gradient(135deg, #FFD700, #FF8C00) !important;
        }
        
        .btn-secondary {
            background: #6c757d !important;
            color: #ffffff !important;
            font-weight: 700 !important;
            border: none !important;
        }
        
        .form-control, .form-select {
            background: #2d2d2d !important;
            border: 2px solid rgba(255, 140, 0, 0.5) !important;
            color: #ffffff !important;
            font-weight: 600 !important;
            border-radius: 8px !important;
        }
        
        .form-control:focus, .form-select:focus {
            background: #2d2d2d !important;
            border-color: #FFD700 !important;
            box-shadow: 0 0 0 0.2rem rgba(255, 215, 0, 0.25) !important;
            color: #ffffff !important;
        }
        
        .form-control::placeholder {
            color: #999999 !important;
        }
        
        .form-label {
            color: #FFD700 !important;
            font-weight: 700 !important;
        }
        
        .alert-danger {
            background: rgba(220, 53, 69, 0.2) !important;
            border: 2px solid #dc3545 !important;
            color: #ffffff !important;
        }
        
        .text-primary {
            color: #FFD700 !important;
        }
        
        select option {
            background: #1a1a1a !important;
            color: #FFD700 !important;
        }
        
        /* === INFORMACIÓN ADICIONAL === */
        .text-sm {
            color: #ffffff !important;
            font-weight: 600 !important;
        }
        
        h6, h6.text-muted {
            color: #FFD700 !important;
            font-weight: 800 !important;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.8);
        }
        
        h6 i, h6.text-muted i {
            color: #FF8C00 !important;
        }
        
        p {
            color: #ffffff !important;
            font-weight: 600 !important;
        }
        
        p strong {
            color: #FFD700 !important;
            font-weight: 800 !important;
        }
        
        .btn-outline-secondary {
            background: #6c757d !important;
            border: 2px solid #6c757d !important;
            color: #ffffff !important;
            font-weight: 700 !important;
        }
        
        .btn-outline-secondary:hover {
            background: #5a6268 !important;
            border-color: #5a6268 !important;
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <?php include __DIR__ . '/../partials/navbar-simple.php'; ?>
    
    <div class="container py-4">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header bg-gradient text-white text-center py-4" style="background: linear-gradient(45deg, #667eea, #764ba2); border-radius: 20px 20px 0 0;">
                        <h3 class="mb-0">
                            <i class="fas fa-user-edit"></i> 
                            Editar Usuario
                        </h3>
                    </div>
                    <div class="card-body p-4">
                        <?php if (isset($error)): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <i class="fas fa-exclamation-circle me-2"></i>
                                <?php echo htmlspecialchars($error); ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>

                        <form method="POST">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="nombre" class="form-label">
                                            <i class="fas fa-user text-primary"></i> Nombre Completo
                                        </label>
                                        <input type="text" class="form-control" id="nombre" name="nombre" 
                                               value="<?php echo htmlspecialchars($usuario['nombre'] ?? ''); ?>" 
                                               required maxlength="100">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="email" class="form-label">
                                            <i class="fas fa-envelope text-primary"></i> Correo Electrónico
                                        </label>
                                        <input type="email" class="form-control" id="email" name="email" 
                                               value="<?php echo htmlspecialchars($usuario['email'] ?? ''); ?>" 
                                               required maxlength="150">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="rol" class="form-label">
                                            <i class="fas fa-user-tag text-primary"></i> Rol
                                        </label>
                                        <select class="form-control" id="rol" name="rol" required>
                                            <option value="">Seleccionar rol...</option>
                                            <option value="administrador" <?php echo ($usuario['rol'] ?? '') === 'administrador' ? 'selected' : ''; ?>>
                                                Administrador
                                            </option>
                                            <option value="encargado" <?php echo ($usuario['rol'] ?? '') === 'encargado' ? 'selected' : ''; ?>>
                                                Encargado
                                            </option>
                                            <option value="auditor" <?php echo ($usuario['rol'] ?? '') === 'auditor' ? 'selected' : ''; ?>>
                                                Auditor
                                            </option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="estado" class="form-label">
                                            <i class="fas fa-toggle-on text-primary"></i> Estado
                                        </label>
                                        <select class="form-control" id="estado" name="estado" required>
                                            <option value="">Seleccionar estado...</option>
                                            <option value="activo" <?php echo ($usuario['estado'] ?? '') === 'activo' ? 'selected' : ''; ?>>
                                                Activo
                                            </option>
                                            <option value="inactivo" <?php echo ($usuario['estado'] ?? '') === 'inactivo' ? 'selected' : ''; ?>>
                                                Inactivo
                                            </option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="d-flex justify-content-between align-items-center mt-4">
                                <a href="/app-web-Enciso/public/usuarios" class="btn btn-outline-secondary">
                                    <i class="fas fa-arrow-left"></i> Cancelar
                                </a>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> Actualizar Usuario
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Información adicional -->
                <div class="card mt-4">
                    <div class="card-body">
                        <h6 class="text-muted mb-3">
                            <i class="fas fa-info-circle"></i> Información del Usuario
                        </h6>
                        <div class="row text-sm">
                            <div class="col-md-6">
                                <p><strong>ID:</strong> #<?php echo $usuario['id']; ?></p>
                                <p><strong>Creado:</strong> <?php echo date('d/m/Y H:i', strtotime($usuario['fecha_creacion'] ?? '')); ?></p>
                            </div>
                            <div class="col-md-6">
                                <p><strong>Última actualización:</strong> 
                                   <?php echo $usuario['fecha_actualizacion'] ? date('d/m/Y H:i', strtotime($usuario['fecha_actualizacion'])) : 'Nunca'; ?>
                                </p>
                                <p><strong>Último acceso:</strong> 
                                   <?php echo $usuario['ultimo_acceso'] ? date('d/m/Y H:i', strtotime($usuario['ultimo_acceso'])) : 'Nunca'; ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

