<?php
/**
 * PÁGINA DE GESTIÓN DE USUARIOS
 */

// Verificar autenticación
if (!isset($_SESSION['usuario_id'])) {
    header('Location: /app-web-Enciso/public/login');
    exit;
}

// Obtener configuración de base de datos
require_once __DIR__ . '/../../config/config.php';

// Inicializar variables por defecto
$usuarios = [];
$total_usuarios = 0;
$usuarios_activos = 0;
$administradores = 0;

try {
    $pdo = new PDO($dsn, $username, $password, $options);
    
    // Obtener filtros
    $buscar = $_GET['buscar'] ?? '';
    $rol_filter = $_GET['rol'] ?? '';
    $estado_filter = $_GET['estado'] ?? '';
    
    // Construir consulta con filtros
    $where_conditions = [];
    $params = [];
    
    if (!empty($buscar)) {
        $where_conditions[] = "(nombre LIKE ? OR email LIKE ?)";
        $params[] = "%$buscar%";
        $params[] = "%$buscar%";
    }
    
    if (!empty($rol_filter)) {
        $where_conditions[] = "rol = ?";
        $params[] = $rol_filter;
    }
    
    if (!empty($estado_filter)) {
        $where_conditions[] = $estado_filter === 'activo' ? "activo = 1" : "activo = 0";
    }
    
    $where_clause = !empty($where_conditions) ? 'WHERE ' . implode(' AND ', $where_conditions) : '';
    
    // Obtener usuarios
    $stmt = $pdo->prepare("
        SELECT *, 
               (SELECT COUNT(*) FROM movimientos_inventario WHERE usuario_id = usuarios.id) as total_movimientos,
               CASE WHEN activo = 1 THEN 'activo' ELSE 'inactivo' END as estado
        FROM usuarios 
        $where_clause 
        ORDER BY nombre ASC
    ");
    $stmt->execute($params);
    $usuarios = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Obtener estadísticas
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM usuarios");
    $total_usuarios = $stmt->fetch()['total'];
    
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM usuarios WHERE activo = 1");
    $usuarios_activos = $stmt->fetch()['total'];
    
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM usuarios WHERE rol = 'administrador'");
    $administradores = $stmt->fetch()['total'];
    
} catch (Exception $e) {
    $error = "Error de base de datos: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Usuarios - Sistema de Gestión</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        /* === TEMA CAYEJERO GAMING === */
        * {
            background-color: transparent !important;
        }
        
        body, html {
            background: #0a0a0a !important;
            min-height: 100vh;
            color: #ffffff !important;
            font-family: 'Segoe UI', system-ui, sans-serif !important;
        }
        
        .card {
            background: #1a1a1a !important;
            border: 2px solid rgba(255, 140, 0, 0.3) !important;
            border-radius: 15px !important;
            box-shadow: 0 8px 32px rgba(255, 140, 0, 0.1) !important;
        }
        
        .card-header {
            background: linear-gradient(135deg, #FF8C00, #FFD700) !important;
            color: #000000 !important;
            font-weight: 800 !important;
            border-radius: 13px 13px 0 0 !important;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.3);
        }
        
        h1, h2, h3, h4, h5, h6 {
            color: #FFD700 !important;
            font-weight: 800 !important;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.8);
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #FF8C00, #FFD700) !important;
            border: none !important;
            color: #000000 !important;
            font-weight: 700 !important;
            padding: 10px 24px !important;
            transition: all 0.3s ease !important;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px) !important;
            box-shadow: 0 6px 20px rgba(255, 140, 0, 0.4) !important;
            background: linear-gradient(135deg, #FFD700, #FF8C00) !important;
        }
        
        .btn-warning {
            background: #FFD700 !important;
            color: #000000 !important;
            font-weight: 700 !important;
            border: none !important;
        }
        
        .btn-danger {
            background: #dc3545 !important;
            color: #ffffff !important;
            font-weight: 700 !important;
            border: none !important;
        }
        
        .btn-success {
            background: #28a745 !important;
            color: #ffffff !important;
            font-weight: 700 !important;
            border: none !important;
        }
        
        .form-control, .form-select {
            background: #2d2d2d !important;
            border: 2px solid rgba(255, 140, 0, 0.5) !important;
            color: #ffffff !important;
            font-weight: 600 !important;
            border-radius: 8px !important;
        }
        
        .form-control:focus, .form-select:focus {
            background: #2d2d2d !important;
            border-color: #FFD700 !important;
            box-shadow: 0 0 0 0.2rem rgba(255, 215, 0, 0.25) !important;
            color: #ffffff !important;
        }
        
        .form-control::placeholder {
            color: #999999 !important;
        }
        
        .form-label {
            color: #FFD700 !important;
            font-weight: 700 !important;
        }
        
        .table {
            background: #1a1a1a !important;
            border-radius: 10px !important;
            overflow: hidden;
        }
        
        .table thead {
            background: linear-gradient(135deg, #FF8C00, #FFD700) !important;
        }
        
        .table thead th {
            color: #000000 !important;
            font-weight: 800 !important;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.3);
            background: transparent !important;
            border: none !important;
        }
        
        .table tbody tr {
            background-color: #1a1a1a !important;
            border-bottom: 1px solid rgba(255, 140, 0, 0.2) !important;
        }
        
        .table tbody tr:nth-child(even) {
            background-color: #2d2d2d !important;
        }
        
        .table tbody tr:hover {
            background-color: rgba(255, 140, 0, 0.1) !important;
        }
        
        .table tbody td {
            color: #ffffff !important;
            font-weight: 700 !important;
            background: transparent !important;
            border: none !important;
            vertical-align: middle !important;
        }
        
        .badge {
            font-weight: 700 !important;
            padding: 6px 12px !important;
        }
        
        .badge.bg-success {
            background: #28a745 !important;
            color: #ffffff !important;
        }
        
        .badge.bg-danger {
            background: #dc3545 !important;
            color: #ffffff !important;
        }
        
        .badge.bg-primary {
            background: linear-gradient(135deg, #FF8C00, #FFD700) !important;
            color: #000000 !important;
        }
        
        .badge.bg-warning {
            background: #FFD700 !important;
            color: #000000 !important;
        }
        
        .stat-card {
            background: linear-gradient(135deg, rgba(255, 140, 0, 0.2), rgba(255, 215, 0, 0.2)) !important;
            border: 2px solid rgba(255, 140, 0, 0.4) !important;
            border-radius: 12px !important;
            padding: 20px !important;
            text-align: center !important;
        }
        
        .stat-card h3 {
            color: #FFD700 !important;
            font-weight: 800 !important;
            margin: 0 !important;
        }
        
        .stat-card p {
            color: #ffffff !important;
            font-weight: 600 !important;
            margin: 5px 0 0 0 !important;
        }
        
        .alert-success {
            background: rgba(40, 167, 69, 0.2) !important;
            border: 2px solid #28a745 !important;
            color: #ffffff !important;
        }
        
        .alert-danger {
            background: rgba(220, 53, 69, 0.2) !important;
            border: 2px solid #dc3545 !important;
            color: #ffffff !important;
        }
        
        .btn-sm {
            border-radius: 8px !important;
            margin: 2px !important;
            font-weight: 700 !important;
        }
        
        /* === NAVBAR STYLING === */
        nav.navbar {
            background: linear-gradient(135deg, #000000, #1a1a1a) !important;
            border-bottom: 3px solid rgba(255, 140, 0, 0.5) !important;
        }
        
        .navbar-brand, .nav-link {
            color: #FFD700 !important;
            font-weight: 700 !important;
        }
        
        .nav-link:hover {
            color: #FF8C00 !important;
        }
        
        /* === ESTADÍSTICAS === */
        .card.text-center .card-body {
            background: #1a1a1a !important;
            padding: 20px !important;
        }
        
        .card.text-center h4 {
            color: #FFD700 !important;
            font-weight: 900 !important;
            font-size: 2rem !important;
        }
        
        .card.text-center p {
            color: #ffffff !important;
            font-weight: 600 !important;
        }
        
        .text-muted {
            color: #e0e0e0 !important;
        }
        
        .text-success {
            color: #28a745 !important;
        }
        
        .text-danger {
            color: #dc3545 !important;
        }
        
        .text-info {
            color: #17a2b8 !important;
        }
        
        /* === ICONOS === */
        .fa, .fas, .far {
            color: inherit !important;
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <?php include __DIR__ . '/../partials/navbar-simple.php'; ?>
    
    <div class="container-fluid py-4">
        <!-- Header -->
        <div class="row">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h2"><i class="fas fa-users text-primary"></i> Gestión de Usuarios</h1>
                    <?php if (($_SESSION['rol'] ?? '') === 'administrador'): ?>
                    <a href="/app-web-Enciso/public/usuarios/agregar" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Nuevo Usuario
                    </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Mensajes -->
        <?php if (isset($_SESSION['success_message'])): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle me-2"></i>
                <?php echo htmlspecialchars($_SESSION['success_message']); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php unset($_SESSION['success_message']); ?>
        <?php endif; ?>

        <?php if (isset($error)): ?>
            <div class="alert alert-danger" role="alert">
                <i class="fas fa-exclamation-circle me-2"></i>
                <?php echo htmlspecialchars($error); ?>
            </div>
        <?php endif; ?>

        <!-- Filtros -->
        <form method="GET" class="mb-4">
            <div class="row">
                <div class="col-md-4">
                    <input type="text" class="form-control" name="buscar" 
                           placeholder="Buscar por nombre o email..."
                           value="<?php echo htmlspecialchars($buscar); ?>">
                </div>
                <div class="col-md-3">
                    <select class="form-control" name="rol">
                        <option value="">Todos los roles</option>
                        <option value="administrador" <?php echo $rol_filter === 'administrador' ? 'selected' : ''; ?>>Administrador</option>
                        <option value="encargado" <?php echo $rol_filter === 'encargado' ? 'selected' : ''; ?>>Encargado</option>
                        <option value="auditor" <?php echo $rol_filter === 'auditor' ? 'selected' : ''; ?>>Auditor</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <select class="form-control" name="estado">
                        <option value="">Todos los estados</option>
                        <option value="activo" <?php echo $estado_filter === 'activo' ? 'selected' : ''; ?>>Activo</option>
                        <option value="inactivo" <?php echo $estado_filter === 'inactivo' ? 'selected' : ''; ?>>Inactivo</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-outline-primary w-100">
                        <i class="fas fa-search"></i> Buscar
                    </button>
                </div>
            </div>
        </form>

        <!-- Tabla de Usuarios -->
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-list"></i> Lista de Usuarios</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Nombre</th>
                                <th>Email</th>
                                <th>Rol</th>
                                <th>Estado</th>
                                <th>Último Acceso</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($usuarios)): ?>
                                <tr>
                                    <td colspan="7" class="text-center py-4">
                                        <i class="fas fa-users fa-3x text-muted mb-3"></i>
                                        <p class="text-muted">No se encontraron usuarios</p>
                                    </td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($usuarios as $usuario): ?>
                                <tr>
                                    <td><?php echo $usuario['id']; ?></td>
                                    <td><?php echo htmlspecialchars($usuario['nombre']); ?></td>
                                    <td><?php echo htmlspecialchars($usuario['email']); ?></td>
                                    <td>
                                        <span class="badge 
                                            <?php 
                                                echo $usuario['rol'] === 'administrador' ? 'bg-danger' : 
                                                    ($usuario['rol'] === 'encargado' ? 'bg-primary' : 'bg-info'); 
                                            ?>">
                                            <?php echo ucfirst($usuario['rol']); ?>
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge <?php echo $usuario['estado'] === 'activo' ? 'bg-success' : 'bg-secondary'; ?>">
                                            <?php echo ucfirst($usuario['estado']); ?>
                                        </span>
                                    </td>
                                    <td>
                                        <?php 
                                            if ($usuario['ultimo_acceso']) {
                                                echo date('d/m/Y H:i', strtotime($usuario['ultimo_acceso']));
                                            } else {
                                                echo '<span class="text-muted">Nunca</span>';
                                            }
                                        ?>
                                    </td>
                                    <td>
                                        <?php if (($_SESSION['rol'] ?? '') === 'administrador' || $usuario['id'] == $_SESSION['usuario_id']): ?>
                                            <a href="/app-web-Enciso/public/usuarios/editar?id=<?php echo $usuario['id']; ?>" 
                                               class="btn btn-sm btn-outline-primary" title="Editar">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                        <?php endif; ?>
                                        
                                        <?php if (($_SESSION['rol'] ?? '') === 'administrador' || $usuario['id'] == $_SESSION['usuario_id']): ?>
                                            <a href="/app-web-Enciso/public/usuarios/cambiar-password?id=<?php echo $usuario['id']; ?>" 
                                               class="btn btn-sm btn-outline-warning" title="Cambiar contraseña">
                                                <i class="fas fa-key"></i>
                                            </a>
                                        <?php endif; ?>
                                        
                                        <a href="/app-web-Enciso/public/usuarios/perfil?id=<?php echo $usuario['id']; ?>" 
                                           class="btn btn-sm btn-outline-secondary" title="Ver perfil">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Estadísticas -->
        <div class="row mt-4">
            <div class="col-md-3">
                <div class="card text-center">
                    <div class="card-body">
                        <i class="fas fa-users fa-2x text-primary mb-2"></i>
                        <h4><?php echo $total_usuarios ?? 0; ?></h4>
                        <p class="text-muted">Total Usuarios</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-center">
                    <div class="card-body">
                        <i class="fas fa-user-check fa-2x text-success mb-2"></i>
                        <h4><?php echo $usuarios_activos ?? 0; ?></h4>
                        <p class="text-muted">Activos</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-center">
                    <div class="card-body">
                        <i class="fas fa-user-shield fa-2x text-danger mb-2"></i>
                        <h4><?php echo $administradores ?? 0; ?></h4>
                        <p class="text-muted">Administradores</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-center">
                    <div class="card-body">
                        <i class="fas fa-filter fa-2x text-info mb-2"></i>
                        <h4><?php echo isset($usuarios) ? count($usuarios) : 0; ?></h4>
                        <p class="text-muted">Encontrados</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

