<?php
/**
 * PÁGINA DE PERFIL DE USUARIO
 */

// Verificar autenticación
if (!isset($_SESSION['usuario_id'])) {
    header('Location: /app-web-Enciso/public/login');
    exit;
}

// Obtener configuración de base de datos
require_once __DIR__ . '/../../config/config.php';

// Obtener ID del usuario
$usuario_id = isset($_GET['id']) ? intval($_GET['id']) : $_SESSION['usuario_id'];

try {
    $pdo = new PDO($dsn, $username, $password, $options);
    
    // Obtener datos del usuario
    $stmt = $pdo->prepare("
        SELECT u.*, 
               COUNT(m.id) as total_movimientos,
               MAX(m.fecha_movimiento) as ultimo_movimiento,
               CASE WHEN u.activo = 1 THEN 'activo' ELSE 'inactivo' END as estado
        FROM usuarios u
        LEFT JOIN movimientos_inventario m ON u.id = m.usuario_id
        WHERE u.id = ?
        GROUP BY u.id
    ");
    $stmt->execute([$usuario_id]);
    $usuario = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$usuario) {
        header('Location: /app-web-Enciso/public/usuarios');
        exit;
    }
    
    // Obtener estadísticas de actividad del usuario
    $stmt = $pdo->prepare("
        SELECT 
            DATE(m.fecha_movimiento) as fecha,
            COUNT(*) as movimientos
        FROM movimientos_inventario m 
        WHERE m.usuario_id = ? 
        AND m.fecha_movimiento >= DATE_SUB(NOW(), INTERVAL 30 DAY)
        GROUP BY DATE(m.fecha_movimiento)
        ORDER BY fecha DESC
        LIMIT 10
    ");
    $stmt->execute([$usuario_id]);
    $actividad_reciente = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Obtener últimos movimientos del usuario
    $stmt = $pdo->prepare("
        SELECT m.*, u.nombre as utensilio_nombre, u.categoria
        FROM movimientos_inventario m
        LEFT JOIN utensilios u ON m.utensilio_id = u.id
        WHERE m.usuario_id = ?
        ORDER BY m.fecha_movimiento DESC
        LIMIT 10
    ");
    $stmt->execute([$usuario_id]);
    $ultimos_movimientos = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
} catch (Exception $e) {
    $error = "Error de base de datos: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Perfil de Usuario - Sistema de Gestión</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        /* === TEMA CAYEJERO GAMING === */
        * {
            background-color: transparent !important;
        }
        
        body, html {
            background: #0a0a0a !important;
            min-height: 100vh;
            color: #ffffff !important;
        }
        
        .card {
            background: #1a1a1a !important;
            border: 2px solid rgba(255, 140, 0, 0.3) !important;
            border-radius: 15px !important;
            box-shadow: 0 8px 32px rgba(255, 140, 0, 0.1) !important;
        }
        
        .card-header {
            background: linear-gradient(135deg, #FF8C00, #FFD700) !important;
            color: #000000 !important;
            font-weight: 800 !important;
            border-radius: 13px 13px 0 0 !important;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.3);
        }
        
        h1, h2, h3, h4, h5, h6 {
            color: #FFD700 !important;
            font-weight: 800 !important;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.8);
        }
        
        .profile-avatar {
            width: 120px;
            height: 120px;
            background: linear-gradient(135deg, #FF8C00, #FFD700) !important;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 48px;
            color: #000000 !important;
            margin: 0 auto 20px;
            font-weight: 900;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.3);
        }
        
        .stat-card {
            background: linear-gradient(135deg, rgba(255, 140, 0, 0.2), rgba(255, 215, 0, 0.2)) !important;
            border: 2px solid rgba(255, 140, 0, 0.4) !important;
            color: white;
            border-radius: 12px !important;
            padding: 20px !important;
            text-align: center;
        }
        
        .stat-card h3 {
            color: #FFD700 !important;
            font-weight: 800 !important;
        }
        
        .stat-card p {
            color: #ffffff !important;
            font-weight: 600 !important;
        }
        
        .activity-item {
            border-left: 3px solid #FF8C00 !important;
            padding-left: 15px;
            margin-bottom: 15px;
        }
        
        .badge {
            font-weight: 700 !important;
            padding: 6px 12px !important;
        }
        
        .badge-role {
            font-size: 14px;
            padding: 8px 16px;
            background: linear-gradient(135deg, #FF8C00, #FFD700) !important;
            color: #000000 !important;
        }
        
        .badge.bg-success {
            background: #28a745 !important;
            color: #ffffff !important;
        }
        
        .badge.bg-danger {
            background: #dc3545 !important;
            color: #ffffff !important;
        }
        
        .badge.bg-primary {
            background: linear-gradient(135deg, #FF8C00, #FFD700) !important;
            color: #000000 !important;
        }
        
        .table {
            background: #1a1a1a !important;
        }
        
        .table thead {
            background: linear-gradient(135deg, #FF8C00, #FFD700) !important;
        }
        
        .table thead th {
            color: #000000 !important;
            font-weight: 800 !important;
            background: transparent !important;
        }
        
        .table tbody tr {
            background-color: #1a1a1a !important;
            border-bottom: 1px solid rgba(255, 140, 0, 0.2) !important;
        }
        
        .table tbody tr:nth-child(even) {
            background-color: #2d2d2d !important;
        }
        
        .table tbody td {
            color: #ffffff !important;
            font-weight: 700 !important;
            background: transparent !important;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #FF8C00, #FFD700) !important;
            border: none !important;
            color: #000000 !important;
            font-weight: 700 !important;
        }
        
        .btn-warning {
            background: #FFD700 !important;
            color: #000000 !important;
            font-weight: 700 !important;
        }
        
        .text-primary {
            color: #FFD700 !important;
        }
        
        .text-muted {
            color: #999999 !important;
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <?php include __DIR__ . '/../partials/navbar-simple.php'; ?>
    
    <div class="container py-4">
        <?php if (isset($error)): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle me-2"></i>
                <?php echo htmlspecialchars($error); ?>
            </div>
        <?php else: ?>
            
        <!-- Encabezado del perfil -->
        <div class="row">
            <div class="col-12">
                <div class="card mb-4">
                    <div class="card-body text-center py-5">
                        <div class="profile-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <h2 class="mb-2"><?php echo htmlspecialchars($usuario['nombre']); ?></h2>
                        <p class="text-muted mb-3">
                            <i class="fas fa-envelope me-2"></i>
                            <?php echo htmlspecialchars($usuario['email']); ?>
                        </p>
                        <div class="mb-3">
                            <span class="badge badge-role 
                                <?php 
                                    echo $usuario['rol'] === 'administrador' ? 'bg-danger' : 
                                        ($usuario['rol'] === 'encargado' ? 'bg-primary' : 'bg-info'); 
                                ?>">
                                <i class="fas fa-user-tag me-1"></i>
                                <?php echo ucfirst($usuario['rol']); ?>
                            </span>
                            <span class="badge badge-role ms-2 
                                <?php echo $usuario['estado'] === 'activo' ? 'bg-success' : 'bg-secondary'; ?>">
                                <i class="fas fa-circle me-1"></i>
                                <?php echo ucfirst($usuario['estado']); ?>
                            </span>
                        </div>
                        
                        <?php if ($usuario_id === $_SESSION['usuario_id'] || ($_SESSION['rol'] ?? '') === 'administrador'): ?>
                        <div class="btn-group" role="group">
                            <a href="/app-web-Enciso/public/usuarios/editar?id=<?php echo $usuario['id']; ?>" 
                               class="btn btn-outline-primary">
                                <i class="fas fa-edit"></i> Editar Perfil
                            </a>
                            <a href="/app-web-Enciso/public/usuarios/cambiar-password?id=<?php echo $usuario['id']; ?>" 
                               class="btn btn-outline-warning">
                                <i class="fas fa-key"></i> Cambiar Contraseña
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Estadísticas -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="stat-card">
                    <i class="fas fa-clipboard-list fa-2x mb-3"></i>
                    <h3><?php echo number_format($usuario['total_movimientos'] ?? 0); ?></h3>
                    <p class="mb-0">Movimientos Realizados</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card">
                    <i class="fas fa-calendar-alt fa-2x mb-3"></i>
                    <h3><?php echo $usuario['fecha_creacion'] ? date('d/m/Y', strtotime($usuario['fecha_creacion'])) : 'N/A'; ?></h3>
                    <p class="mb-0">Fecha de Registro</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card">
                    <i class="fas fa-clock fa-2x mb-3"></i>
                    <h3><?php echo $usuario['ultimo_acceso'] ? date('d/m/Y', strtotime($usuario['ultimo_acceso'])) : 'Nunca'; ?></h3>
                    <p class="mb-0">Último Acceso</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card">
                    <i class="fas fa-sync-alt fa-2x mb-3"></i>
                    <h3><?php echo $usuario['ultimo_movimiento'] ? date('d/m/Y', strtotime($usuario['ultimo_movimiento'])) : 'Ninguno'; ?></h3>
                    <p class="mb-0">Último Movimiento</p>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Información detallada -->
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">
                            <i class="fas fa-info-circle text-primary me-2"></i>
                            Información Detallada
                        </h5>
                    </div>
                    <div class="card-body">
                        <table class="table table-borderless">
                            <tr>
                                <td><strong>ID de Usuario:</strong></td>
                                <td>#<?php echo $usuario['id']; ?></td>
                            </tr>
                            <tr>
                                <td><strong>Nombre Completo:</strong></td>
                                <td><?php echo htmlspecialchars($usuario['nombre']); ?></td>
                            </tr>
                            <tr>
                                <td><strong>Correo Electrónico:</strong></td>
                                <td><?php echo htmlspecialchars($usuario['email']); ?></td>
                            </tr>
                            <tr>
                                <td><strong>Rol del Sistema:</strong></td>
                                <td>
                                    <span class="badge 
                                        <?php 
                                            echo $usuario['rol'] === 'administrador' ? 'bg-danger' : 
                                                ($usuario['rol'] === 'encargado' ? 'bg-primary' : 'bg-info'); 
                                        ?>">
                                        <?php echo ucfirst($usuario['rol']); ?>
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Estado:</strong></td>
                                <td>
                                    <span class="badge <?php echo $usuario['estado'] === 'activo' ? 'bg-success' : 'bg-secondary'; ?>">
                                        <?php echo ucfirst($usuario['estado']); ?>
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Fecha de Creación:</strong></td>
                                <td><?php echo $usuario['fecha_creacion'] ? date('d/m/Y H:i', strtotime($usuario['fecha_creacion'])) : 'No disponible'; ?></td>
                            </tr>
                            <tr>
                                <td><strong>Última Actualización:</strong></td>
                                <td><?php echo $usuario['fecha_actualizacion'] ? date('d/m/Y H:i', strtotime($usuario['fecha_actualizacion'])) : 'Nunca'; ?></td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Actividad reciente -->
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">
                            <i class="fas fa-chart-line text-success me-2"></i>
                            Actividad Reciente
                        </h5>
                    </div>
                    <div class="card-body">
                        <?php if (empty($actividad_reciente)): ?>
                            <p class="text-muted text-center py-3">
                                <i class="fas fa-info-circle me-2"></i>
                                No hay actividad registrada en los últimos 30 días
                            </p>
                        <?php else: ?>
                            <?php foreach ($actividad_reciente as $actividad): ?>
                                <div class="activity-item">
                                    <div class="d-flex justify-content-between">
                                        <span><?php echo date('d/m/Y', strtotime($actividad['fecha'])); ?></span>
                                        <span class="badge bg-primary"><?php echo $actividad['movimientos']; ?> movimientos</span>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Últimos movimientos -->
                <div class="card mt-4">
                    <div class="card-header bg-light">
                        <h6 class="mb-0">
                            <i class="fas fa-history text-info me-2"></i>
                            Últimos 10 Movimientos
                        </h6>
                    </div>
                    <div class="card-body">
                        <?php if (empty($ultimos_movimientos)): ?>
                            <p class="text-muted text-center py-3">
                                <i class="fas fa-info-circle me-2"></i>
                                No hay movimientos registrados
                            </p>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-sm">
                                    <thead>
                                        <tr>
                                            <th>Fecha</th>
                                            <th>Utensilio</th>
                                            <th>Tipo</th>
                                            <th>Cantidad</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($ultimos_movimientos as $mov): ?>
                                        <tr>
                                            <td class="text-sm"><?php echo date('d/m H:i', strtotime($mov['fecha_movimiento'])); ?></td>
                                            <td class="text-sm"><?php echo htmlspecialchars($mov['utensilio_nombre'] ?? 'N/A'); ?></td>
                                            <td>
                                                <span class="badge <?php echo $mov['tipo_movimiento'] === 'entrada' ? 'bg-success' : 'bg-danger'; ?> badge-sm">
                                                    <?php echo ucfirst($mov['tipo_movimiento']); ?>
                                                </span>
                                            </td>
                                            <td class="text-sm"><?php echo $mov['cantidad']; ?></td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Botón de regreso -->
        <div class="row mt-4">
            <div class="col-12 text-center">
                <a href="/app-web-Enciso/public/usuarios" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left me-2"></i>
                    Volver a Lista de Usuarios
                </a>
            </div>
        </div>

        <?php endif; ?>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

