<?php
// Verificar autenticación y permisos
$authService = new AuthService();
$authService->requierePermiso('utensilios_ver');
$usuario = $authService->getUsuarioActual();

// Obtener servicios
$inventarioService = new InventarioService();

// Procesar filtros
$filtros = [];
$busqueda = $_GET['busqueda'] ?? '';
$tipo = $_GET['tipo'] ?? '';
$estado = $_GET['estado'] ?? '';
$ubicacion = $_GET['ubicacion'] ?? '';
$stock_bajo = isset($_GET['stock_bajo']) ? true : false;

if (!empty($tipo)) $filtros['tipo'] = $tipo;
if (!empty($estado)) $filtros['estado'] = $estado;
if (!empty($ubicacion)) $filtros['ubicacion'] = $ubicacion;
if ($stock_bajo) $filtros['stock_bajo'] = true;

try {
    // Obtener utensilios
    if (!empty($busqueda)) {
        $utensilios = $inventarioService->buscar($busqueda, $filtros);
    } else {
        $utensilios = $inventarioService->obtenerTodos($filtros);
    }
    
    // Obtener datos para filtros
    $ubicaciones = $inventarioService->obtenerUbicaciones();
    $estadisticas = $inventarioService->obtenerEstadisticas();
    
} catch (Exception $e) {
    $error = $e->getMessage();
    $utensilios = [];
    $ubicaciones = [];
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Utensilios - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="<?php echo ASSETS_URL; ?>/css/utensilios.css" rel="stylesheet">
</head>
<body>
    <!-- Navbar -->
    <?php include VIEWS_PATH . '/partials/navbar.php'; ?>

    <div class="container-fluid py-4">
        
        <!-- Encabezado -->
        <div class="row mb-4">
            <div class="col-md-6">
                <h1 class="h3 mb-0">
                    <i class="fas fa-utensils text-primary me-2"></i>
                    Gestión de Utensilios
                </h1>
                <p class="text-muted">Administra el inventario de utensilios de cocina</p>
            </div>
            <div class="col-md-6 text-md-end">
                <?php if ($authService->tieneRol('administrador') || $authService->tieneRol('encargado')): ?>
                    <a href="<?php echo BASE_URL; ?>/utensilios/nuevo" class="btn btn-primary">
                        <i class="fas fa-plus me-2"></i>
                        Agregar Utensilio
                    </a>
                <?php endif; ?>
            </div>
        </div>

        <!-- Estadísticas rápidas -->
        <div class="row mb-4">
            <div class="col-lg-3 col-md-6 mb-3">
                <div class="card bg-primary text-white h-100">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <div class="h4 mb-0"><?php echo $estadisticas['generales']['activos'] ?? 0; ?></div>
                                <div class="small">Utensilios Activos</div>
                            </div>
                            <div class="h2"><i class="fas fa-utensils"></i></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-3">
                <div class="card bg-success text-white h-100">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <div class="h4 mb-0"><?php echo $estadisticas['generales']['items_disponibles'] ?? 0; ?></div>
                                <div class="small">Items Disponibles</div>
                            </div>
                            <div class="h2"><i class="fas fa-check-circle"></i></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-3">
                <div class="card bg-warning text-white h-100">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <div class="h4 mb-0"><?php echo $estadisticas['generales']['con_stock_bajo'] ?? 0; ?></div>
                                <div class="small">Stock Bajo</div>
                            </div>
                            <div class="h2"><i class="fas fa-exclamation-triangle"></i></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-3">
                <div class="card bg-info text-white h-100">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <div class="h4 mb-0">$<?php echo number_format($estadisticas['valor_total'] ?? 0, 2); ?></div>
                                <div class="small">Valor Total</div>
                            </div>
                            <div class="h2"><i class="fas fa-dollar-sign"></i></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filtros y búsqueda -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-filter me-2"></i>
                    Filtros y Búsqueda
                </h5>
            </div>
            <div class="card-body">
                <form method="GET" action="<?php echo BASE_URL; ?>/utensilios" class="row g-3">
                    <div class="col-md-4">
                        <label for="busqueda" class="form-label">Buscar</label>
                        <div class="input-group">
                            <span class="input-group-text">
                                <i class="fas fa-search"></i>
                            </span>
                            <input type="text" 
                                   class="form-control" 
                                   id="busqueda" 
                                   name="busqueda" 
                                   placeholder="Nombre o descripción..."
                                   value="<?php echo htmlspecialchars($busqueda); ?>">
                        </div>
                    </div>
                    
                    <div class="col-md-2">
                        <label for="tipo" class="form-label">Tipo</label>
                        <select class="form-select" id="tipo" name="tipo">
                            <option value="">Todos</option>
                            <?php foreach (Utensilio::getTipos() as $key => $value): ?>
                                <option value="<?php echo $key; ?>" 
                                        <?php echo $tipo === $key ? 'selected' : ''; ?>>
                                    <?php echo $value; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="col-md-2">
                        <label for="estado" class="form-label">Estado</label>
                        <select class="form-select" id="estado" name="estado">
                            <option value="">Todos</option>
                            <?php foreach (Utensilio::getEstados() as $key => $value): ?>
                                <option value="<?php echo $key; ?>" 
                                        <?php echo $estado === $key ? 'selected' : ''; ?>>
                                    <?php echo $value; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="col-md-2">
                        <label for="ubicacion" class="form-label">Ubicación</label>
                        <select class="form-select" id="ubicacion" name="ubicacion">
                            <option value="">Todas</option>
                            <?php foreach ($ubicaciones as $ub): ?>
                                <option value="<?php echo htmlspecialchars($ub); ?>" 
                                        <?php echo $ubicacion === $ub ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($ub); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="col-md-2">
                        <label class="form-label">&nbsp;</label>
                        <div class="form-check">
                            <input class="form-check-input" 
                                   type="checkbox" 
                                   id="stock_bajo" 
                                   name="stock_bajo" 
                                   <?php echo $stock_bajo ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="stock_bajo">
                                Solo stock bajo
                            </label>
                        </div>
                        <div class="mt-2">
                            <button type="submit" class="btn btn-primary btn-sm">
                                <i class="fas fa-search me-1"></i> Filtrar
                            </button>
                            <a href="<?php echo BASE_URL; ?>/utensilios" class="btn btn-outline-secondary btn-sm">
                                <i class="fas fa-times me-1"></i> Limpiar
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Mensaje de error -->
        <?php if (isset($error)): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-triangle me-2"></i>
                <?php echo htmlspecialchars($error); ?>
            </div>
        <?php endif; ?>

        <!-- Lista de utensilios -->
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="fas fa-list me-2"></i>
                    Lista de Utensilios (<?php echo count($utensilios); ?>)
                </h5>
                <div class="btn-group btn-group-sm" role="group">
                    <input type="radio" class="btn-check" name="vista" id="vista-tabla" autocomplete="off" checked>
                    <label class="btn btn-outline-primary" for="vista-tabla">
                        <i class="fas fa-table"></i> Tabla
                    </label>
                    <input type="radio" class="btn-check" name="vista" id="vista-tarjetas" autocomplete="off">
                    <label class="btn btn-outline-primary" for="vista-tarjetas">
                        <i class="fas fa-th-large"></i> Tarjetas
                    </label>
                </div>
            </div>
            <div class="card-body p-0">
                
                <!-- Vista de tabla -->
                <div id="tabla-vista">
                    <?php if (!empty($utensilios)): ?>
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Nombre</th>
                                        <th>Tipo</th>
                                        <th>Estado</th>
                                        <th>Ubicación</th>
                                        <th>Disponible</th>
                                        <th>Stock</th>
                                        <th>Precio</th>
                                        <th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($utensilios as $utensilio): ?>
                                        <tr>
                                            <td>
                                                <div class="fw-bold"><?php echo htmlspecialchars($utensilio->nombre); ?></div>
                                                <?php if ($utensilio->descripcion): ?>
                                                    <small class="text-muted"><?php echo htmlspecialchars(substr($utensilio->descripcion, 0, 50)); ?>...</small>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <span class="badge bg-secondary">
                                                    <?php echo Utensilio::getTipos()[$utensilio->tipo] ?? $utensilio->tipo; ?>
                                                </span>
                                            </td>
                                            <td>
                                                <span class="badge bg-<?php echo $utensilio->getClaseEstado(); ?>">
                                                    <?php echo Utensilio::getEstados()[$utensilio->estado] ?? $utensilio->estado; ?>
                                                </span>
                                            </td>
                                            <td>
                                                <i class="fas fa-map-marker-alt text-muted me-1"></i>
                                                <?php echo htmlspecialchars($utensilio->ubicacion); ?>
                                            </td>
                                            <td>
                                                <span class="fw-bold <?php echo $utensilio->tieneStockBajo() ? 'text-danger' : 'text-success'; ?>">
                                                    <?php echo $utensilio->cantidad_disponible; ?>
                                                </span>
                                                / <?php echo $utensilio->cantidad_total; ?>
                                            </td>
                                            <td>
                                                <div class="progress" style="height: 20px;">
                                                    <?php
                                                    $porcentaje = $utensilio->getPorcentajeDisponibilidad();
                                                    $clase = $porcentaje <= 25 ? 'bg-danger' : ($porcentaje <= 50 ? 'bg-warning' : 'bg-success');
                                                    ?>
                                                    <div class="progress-bar <?php echo $clase; ?>" 
                                                         style="width: <?php echo $porcentaje; ?>%">
                                                        <?php echo $porcentaje; ?>%
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <span class="text-muted">$</span><?php echo number_format($utensilio->precio_unitario, 2); ?>
                                            </td>
                                            <td>
                                                <div class="btn-group btn-group-sm" role="group">
                                                    <a href="<?php echo BASE_URL; ?>/utensilios/ver/<?php echo $utensilio->id; ?>" 
                                                       class="btn btn-outline-info" 
                                                       title="Ver detalles">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <?php if ($authService->tieneRol('administrador') || $authService->tieneRol('encargado')): ?>
                                                        <a href="<?php echo BASE_URL; ?>/utensilios/editar/<?php echo $utensilio->id; ?>" 
                                                           class="btn btn-outline-primary" 
                                                           title="Editar">
                                                            <i class="fas fa-edit"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                    <?php if ($authService->esAdministrador()): ?>
                                                        <button type="button" 
                                                                class="btn btn-outline-danger" 
                                                                onclick="confirmarEliminacion(<?php echo $utensilio->id; ?>, '<?php echo htmlspecialchars($utensilio->nombre); ?>')"
                                                                title="Eliminar">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-5">
                            <i class="fas fa-utensils fa-3x text-muted mb-3"></i>
                            <h5 class="text-muted">No se encontraron utensilios</h5>
                            <p class="text-muted">
                                <?php if (!empty($busqueda) || !empty(array_filter($filtros))): ?>
                                    Intenta ajustar los filtros de búsqueda
                                <?php else: ?>
                                    Comienza agregando tu primer utensilio al inventario
                                <?php endif; ?>
                            </p>
                            <?php if ($authService->tieneRol('administrador') || $authService->tieneRol('encargado')): ?>
                                <a href="<?php echo BASE_URL; ?>/utensilios/nuevo" class="btn btn-primary">
                                    <i class="fas fa-plus me-2"></i>
                                    Agregar Primer Utensilio
                                </a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Vista de tarjetas -->
                <div id="tarjetas-vista" style="display: none;">
                    <div class="row p-3">
                        <?php foreach ($utensilios as $utensilio): ?>
                            <div class="col-lg-4 col-md-6 mb-3">
                                <div class="card h-100 utensilio-card">
                                    <div class="card-body">
                                        <div class="d-flex justify-content-between align-items-start mb-2">
                                            <h6 class="card-title mb-0"><?php echo htmlspecialchars($utensilio->nombre); ?></h6>
                                            <span class="badge bg-<?php echo $utensilio->getClaseEstado(); ?>">
                                                <?php echo Utensilio::getEstados()[$utensilio->estado] ?? $utensilio->estado; ?>
                                            </span>
                                        </div>
                                        
                                        <p class="card-text small text-muted mb-2">
                                            <?php echo htmlspecialchars(substr($utensilio->descripcion ?? '', 0, 60)); ?>
                                            <?php echo strlen($utensilio->descripcion ?? '') > 60 ? '...' : ''; ?>
                                        </p>
                                        
                                        <div class="row text-center mb-3">
                                            <div class="col-4">
                                                <small class="text-muted">Disponible</small>
                                                <div class="fw-bold <?php echo $utensilio->tieneStockBajo() ? 'text-danger' : 'text-success'; ?>">
                                                    <?php echo $utensilio->cantidad_disponible; ?>
                                                </div>
                                            </div>
                                            <div class="col-4">
                                                <small class="text-muted">Total</small>
                                                <div class="fw-bold"><?php echo $utensilio->cantidad_total; ?></div>
                                            </div>
                                            <div class="col-4">
                                                <small class="text-muted">Precio</small>
                                                <div class="fw-bold">$<?php echo number_format($utensilio->precio_unitario, 0); ?></div>
                                            </div>
                                        </div>
                                        
                                        <div class="d-flex justify-content-between align-items-center">
                                            <small class="text-muted">
                                                <i class="fas fa-map-marker-alt me-1"></i>
                                                <?php echo htmlspecialchars($utensilio->ubicacion); ?>
                                            </small>
                                            <div class="btn-group btn-group-sm" role="group">
                                                <a href="<?php echo BASE_URL; ?>/utensilios/ver/<?php echo $utensilio->id; ?>" 
                                                   class="btn btn-outline-info btn-sm">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <?php if ($authService->tieneRol('administrador') || $authService->tieneRol('encargado')): ?>
                                                    <a href="<?php echo BASE_URL; ?>/utensilios/editar/<?php echo $utensilio->id; ?>" 
                                                       class="btn btn-outline-primary btn-sm">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal de confirmación de eliminación -->
    <div class="modal fade" id="modalEliminar" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="fas fa-exclamation-triangle text-danger me-2"></i>
                        Confirmar Eliminación
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p>¿Está seguro de que desea eliminar el utensilio <strong id="nombreUtensilio"></strong>?</p>
                    <p class="text-muted small">Esta acción marcará el utensilio como inactivo y no se podrá deshacer.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-danger" id="btnEliminar">
                        <i class="fas fa-trash me-2"></i>
                        Eliminar
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo ASSETS_URL; ?>/js/utensilios.js"></script>
</body>
</html>